@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cloudwatchLogGroupName The name of the CloudWatch log group where you want to send command output. If you don't specify a group name, Systems Manager automatically creates a log group for you. The log group uses the following naming format: aws/ssm/SystemsManagerDocumentName.
 * @property cloudwatchOutputEnabled Enables Systems Manager to send command output to CloudWatch Logs.
 */
public data class MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig(
    public val cloudwatchLogGroupName: String? = null,
    public val cloudwatchOutputEnabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig):
            MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig =
            MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersCloudwatchConfig(
                cloudwatchLogGroupName = javaType.cloudwatchLogGroupName().map({ args0 -> args0 }).orElse(null),
                cloudwatchOutputEnabled = javaType.cloudwatchOutputEnabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
