@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property notificationArn An Amazon Resource Name (ARN) for a Simple Notification Service (SNS) topic. Run Command pushes notifications about command status changes to this topic.
 * @property notificationEvents The different events for which you can receive notifications. Valid values: `All`, `InProgress`, `Success`, `TimedOut`, `Cancelled`, and `Failed`
 * @property notificationType When specified with `Command`, receive notification when the status of a command changes. When specified with `Invocation`, for commands sent to multiple instances, receive notification on a per-instance basis when the status of a command changes. Valid values: `Command` and `Invocation`
 */
public data class
MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig(
    public val notificationArn: String? = null,
    public val notificationEvents: List<String>? = null,
    public val notificationType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig):
            MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig =
            MaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig(
                notificationArn = javaType.notificationArn().map({ args0 -> args0 }).orElse(null),
                notificationEvents = javaType.notificationEvents().map({ args0 -> args0 }),
                notificationType = javaType.notificationType().map({ args0 -> args0 }).orElse(null),
            )
    }
}
