@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssm.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property approveAfterDays The number of days after the release date of each patch matched by the rule the patch is marked as approved in the patch baseline.
 * Valid Range: 0 to 100.
 * Conflicts with `approve_until_date`.
 * @property approveUntilDate The cutoff date for auto approval of released patches.
 * Any patches released on or before this date are installed automatically.
 * Date is formatted as `YYYY-MM-DD`.
 * Conflicts with `approve_after_days`
 * @property complianceLevel The compliance level for patches approved by this rule.
 * Valid values are `CRITICAL`, `HIGH`, `MEDIUM`, `LOW`, `INFORMATIONAL`, and `UNSPECIFIED`.
 * The default value is `UNSPECIFIED`.
 * @property enableNonSecurity Boolean enabling the application of non-security updates.
 * The default value is `false`.
 * Valid for Linux instances only.
 * @property patchFilters The patch filter group that defines the criteria for the rule.
 * Up to 5 patch filters can be specified per approval rule using Key/Value pairs.
 * Valid combinations of these Keys and the `operating_system` value can be found in the [SSM DescribePatchProperties API Reference](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_DescribePatchProperties.html).
 * Valid Values are exact values for the patch property given as the key, or a wildcard `*`, which matches all values.
 */
public data class PatchBaselineApprovalRule(
    public val approveAfterDays: Int? = null,
    public val approveUntilDate: String? = null,
    public val complianceLevel: String? = null,
    public val enableNonSecurity: Boolean? = null,
    public val patchFilters: List<PatchBaselineApprovalRulePatchFilter>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssm.outputs.PatchBaselineApprovalRule):
            PatchBaselineApprovalRule = PatchBaselineApprovalRule(
            approveAfterDays = javaType.approveAfterDays().map({ args0 -> args0 }).orElse(null),
            approveUntilDate = javaType.approveUntilDate().map({ args0 -> args0 }).orElse(null),
            complianceLevel = javaType.complianceLevel().map({ args0 -> args0 }).orElse(null),
            enableNonSecurity = javaType.enableNonSecurity().map({ args0 -> args0 }).orElse(null),
            patchFilters = javaType.patchFilters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssm.kotlin.outputs.PatchBaselineApprovalRulePatchFilter.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
