@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Contact].
 */
@PulumiTagMarker
public class ContactResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContactArgs = ContactArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContactArgsBuilder.() -> Unit) {
        val builder = ContactArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Contact {
        val builtJavaResource = com.pulumi.aws.ssmcontacts.Contact(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Contact(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SSM Contact.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmcontacts.Contact;
 * import com.pulumi.aws.ssmcontacts.ContactArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Contact("example", ContactArgs.builder()
 *             .alias("alias")
 *             .type("PERSONAL")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_ssmincidents_replication_set.example())
 *                 .build());
 *     }
 * }
 * ```
 * ### Usage With All Fields
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmcontacts.Contact;
 * import com.pulumi.aws.ssmcontacts.ContactArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Contact("example", ContactArgs.builder()
 *             .alias("alias")
 *             .displayName("displayName")
 *             .type("ESCALATION")
 *             .tags(Map.of("key", "value"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_ssmincidents_replication_set.example())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSM Contact using the `ARN`. For example:
 * ```sh
 *  $ pulumi import aws:ssmcontacts/contact:Contact example {ARNValue}
 * ```
 *
 */
public class Contact internal constructor(
    override val javaResource: com.pulumi.aws.ssmcontacts.Contact,
) : KotlinCustomResource(javaResource, ContactMapper) {
    /**
     * A unique and identifiable alias for the contact or escalation plan. Must be between 1 and 255 characters, and may contain alphanumerics, underscores (`_`), and hyphens (`-`).
     */
    public val alias: Output<String>
        get() = javaResource.alias().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the contact or escalation plan.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Full friendly name of the contact or escalation plan. If set, must be between 1 and 255 characters, and may contain alphanumerics, underscores (`_`), hyphens (`-`), periods (`.`), and spaces.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of contact engaged. A single contact is type PERSONAL and an escalation
     * plan is type ESCALATION.
     * The following arguments are optional:
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ContactMapper : ResourceMapper<Contact> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssmcontacts.Contact::class == javaResource::class

    override fun map(javaResource: Resource): Contact = Contact(
        javaResource as
            com.pulumi.aws.ssmcontacts.Contact,
    )
}

/**
 * @see [Contact].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Contact].
 */
public suspend fun contact(name: String, block: suspend ContactResourceBuilder.() -> Unit):
    Contact {
    val builder = ContactResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Contact].
 * @param name The _unique_ name of the resulting resource.
 */
public fun contact(name: String): Contact {
    val builder = ContactResourceBuilder()
    builder.name(name)
    return builder.build()
}
