@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin

import com.pulumi.aws.ssmcontacts.ContactArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SSM Contact.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmcontacts.Contact;
 * import com.pulumi.aws.ssmcontacts.ContactArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Contact("example", ContactArgs.builder()
 *             .alias("alias")
 *             .type("PERSONAL")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_ssmincidents_replication_set.example())
 *                 .build());
 *     }
 * }
 * ```
 * ### Usage With All Fields
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmcontacts.Contact;
 * import com.pulumi.aws.ssmcontacts.ContactArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Contact("example", ContactArgs.builder()
 *             .alias("alias")
 *             .displayName("displayName")
 *             .type("ESCALATION")
 *             .tags(Map.of("key", "value"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_ssmincidents_replication_set.example())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSM Contact using the `ARN`. For example:
 * ```sh
 *  $ pulumi import aws:ssmcontacts/contact:Contact example {ARNValue}
 * ```
 * @property alias A unique and identifiable alias for the contact or escalation plan. Must be between 1 and 255 characters, and may contain alphanumerics, underscores (`_`), and hyphens (`-`).
 * @property displayName Full friendly name of the contact or escalation plan. If set, must be between 1 and 255 characters, and may contain alphanumerics, underscores (`_`), hyphens (`-`), periods (`.`), and spaces.
 * @property tags Map of tags to assign to the resource.
 * @property type The type of contact engaged. A single contact is type PERSONAL and an escalation
 * plan is type ESCALATION.
 * The following arguments are optional:
 */
public data class ContactArgs(
    public val alias: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssmcontacts.ContactArgs> {
    override fun toJava(): com.pulumi.aws.ssmcontacts.ContactArgs =
        com.pulumi.aws.ssmcontacts.ContactArgs.builder()
            .alias(alias?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactArgs].
 */
@PulumiTagMarker
public class ContactArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var displayName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value A unique and identifiable alias for the contact or escalation plan. Must be between 1 and 255 characters, and may contain alphanumerics, underscores (`_`), and hyphens (`-`).
     */
    @JvmName("eyjlqetyktkwiwqs")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value Full friendly name of the contact or escalation plan. If set, must be between 1 and 255 characters, and may contain alphanumerics, underscores (`_`), hyphens (`-`), periods (`.`), and spaces.
     */
    @JvmName("nvkgakvebbylwsag")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Map of tags to assign to the resource.
     */
    @JvmName("ubipyedamryajcab")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of contact engaged. A single contact is type PERSONAL and an escalation
     * plan is type ESCALATION.
     * The following arguments are optional:
     */
    @JvmName("dgmqlvksykhgixwf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value A unique and identifiable alias for the contact or escalation plan. Must be between 1 and 255 characters, and may contain alphanumerics, underscores (`_`), and hyphens (`-`).
     */
    @JvmName("gkjxuvyscmejbmvw")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value Full friendly name of the contact or escalation plan. If set, must be between 1 and 255 characters, and may contain alphanumerics, underscores (`_`), hyphens (`-`), periods (`.`), and spaces.
     */
    @JvmName("pjridyymmfecesho")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Map of tags to assign to the resource.
     */
    @JvmName("wvvappnxtysacfbw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource.
     */
    @JvmName("bfktsaybwnhnghkg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of contact engaged. A single contact is type PERSONAL and an escalation
     * plan is type ESCALATION.
     * The following arguments are optional:
     */
    @JvmName("acjpcebjopjdupdg")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ContactArgs = ContactArgs(
        alias = alias,
        displayName = displayName,
        tags = tags,
        type = type,
    )
}
