@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin

import com.pulumi.aws.ssmcontacts.kotlin.outputs.ContactChannelDeliveryAddress
import com.pulumi.aws.ssmcontacts.kotlin.outputs.ContactChannelDeliveryAddress.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ContactChannel].
 */
@PulumiTagMarker
public class ContactChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContactChannelArgs = ContactChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContactChannelArgsBuilder.() -> Unit) {
        val builder = ContactChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ContactChannel {
        val builtJavaResource = com.pulumi.aws.ssmcontacts.ContactChannel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ContactChannel(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SSM Contacts Contact Channel.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmcontacts.ContactChannel;
 * import com.pulumi.aws.ssmcontacts.ContactChannelArgs;
 * import com.pulumi.aws.ssmcontacts.inputs.ContactChannelDeliveryAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContactChannel("example", ContactChannelArgs.builder()
 *             .contactId("arn:aws:ssm-contacts:us-west-2:123456789012:contact/contactalias")
 *             .deliveryAddress(ContactChannelDeliveryAddressArgs.builder()
 *                 .simpleAddress("email@example.com")
 *                 .build())
 *             .type("EMAIL")
 *             .build());
 *     }
 * }
 * ```
 * ### Usage with SSM Contact
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmcontacts.Contact;
 * import com.pulumi.aws.ssmcontacts.ContactArgs;
 * import com.pulumi.aws.ssmcontacts.ContactChannel;
 * import com.pulumi.aws.ssmcontacts.ContactChannelArgs;
 * import com.pulumi.aws.ssmcontacts.inputs.ContactChannelDeliveryAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleContact = new Contact("exampleContact", ContactArgs.builder()
 *             .alias("example_contact")
 *             .type("PERSONAL")
 *             .build());
 *         var example = new ContactChannel("example", ContactChannelArgs.builder()
 *             .contactId(exampleContact.arn())
 *             .deliveryAddress(ContactChannelDeliveryAddressArgs.builder()
 *                 .simpleAddress("email@example.com")
 *                 .build())
 *             .type("EMAIL")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSM Contact Channel using the `ARN`. For example:
 * ```sh
 *  $ pulumi import aws:ssmcontacts/contactChannel:ContactChannel example arn:aws:ssm-contacts:us-west-2:123456789012:contact-channel/example
 * ```
 *
 */
public class ContactChannel internal constructor(
    override val javaResource: com.pulumi.aws.ssmcontacts.ContactChannel,
) : KotlinCustomResource(javaResource, ContactChannelMapper) {
    /**
     * Whether the contact channel is activated. The contact channel must be activated to use it to engage the contact. One of `ACTIVATED` or `NOT_ACTIVATED`.
     */
    public val activationStatus: Output<String>
        get() = javaResource.activationStatus().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the contact channel.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the AWS SSM Contact that the contact channel belongs to.
     */
    public val contactId: Output<String>
        get() = javaResource.contactId().applyValue({ args0 -> args0 })

    /**
     * Block that contains contact engagement details. See details below.
     */
    public val deliveryAddress: Output<ContactChannelDeliveryAddress>
        get() = javaResource.deliveryAddress().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Name of the contact channel. Must be between 1 and 255 characters, and may contain alphanumerics, underscores (`_`), hyphens (`-`), periods (`.`), and spaces.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Type of the contact channel. One of `SMS`, `VOICE` or `EMAIL`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ContactChannelMapper : ResourceMapper<ContactChannel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssmcontacts.ContactChannel::class == javaResource::class

    override fun map(javaResource: Resource): ContactChannel = ContactChannel(
        javaResource as
            com.pulumi.aws.ssmcontacts.ContactChannel,
    )
}

/**
 * @see [ContactChannel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContactChannel].
 */
public suspend fun contactChannel(
    name: String,
    block: suspend ContactChannelResourceBuilder.() -> Unit,
): ContactChannel {
    val builder = ContactChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContactChannel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun contactChannel(name: String): ContactChannel {
    val builder = ContactChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
