@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin

import com.pulumi.aws.ssmcontacts.ContactChannelArgs.builder
import com.pulumi.aws.ssmcontacts.kotlin.inputs.ContactChannelDeliveryAddressArgs
import com.pulumi.aws.ssmcontacts.kotlin.inputs.ContactChannelDeliveryAddressArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SSM Contacts Contact Channel.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmcontacts.ContactChannel;
 * import com.pulumi.aws.ssmcontacts.ContactChannelArgs;
 * import com.pulumi.aws.ssmcontacts.inputs.ContactChannelDeliveryAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContactChannel("example", ContactChannelArgs.builder()
 *             .contactId("arn:aws:ssm-contacts:us-west-2:123456789012:contact/contactalias")
 *             .deliveryAddress(ContactChannelDeliveryAddressArgs.builder()
 *                 .simpleAddress("email@example.com")
 *                 .build())
 *             .type("EMAIL")
 *             .build());
 *     }
 * }
 * ```
 * ### Usage with SSM Contact
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmcontacts.Contact;
 * import com.pulumi.aws.ssmcontacts.ContactArgs;
 * import com.pulumi.aws.ssmcontacts.ContactChannel;
 * import com.pulumi.aws.ssmcontacts.ContactChannelArgs;
 * import com.pulumi.aws.ssmcontacts.inputs.ContactChannelDeliveryAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleContact = new Contact("exampleContact", ContactArgs.builder()
 *             .alias("example_contact")
 *             .type("PERSONAL")
 *             .build());
 *         var example = new ContactChannel("example", ContactChannelArgs.builder()
 *             .contactId(exampleContact.arn())
 *             .deliveryAddress(ContactChannelDeliveryAddressArgs.builder()
 *                 .simpleAddress("email@example.com")
 *                 .build())
 *             .type("EMAIL")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSM Contact Channel using the `ARN`. For example:
 * ```sh
 *  $ pulumi import aws:ssmcontacts/contactChannel:ContactChannel example arn:aws:ssm-contacts:us-west-2:123456789012:contact-channel/example
 * ```
 * @property contactId Amazon Resource Name (ARN) of the AWS SSM Contact that the contact channel belongs to.
 * @property deliveryAddress Block that contains contact engagement details. See details below.
 * @property name Name of the contact channel. Must be between 1 and 255 characters, and may contain alphanumerics, underscores (`_`), hyphens (`-`), periods (`.`), and spaces.
 * @property type Type of the contact channel. One of `SMS`, `VOICE` or `EMAIL`.
 */
public data class ContactChannelArgs(
    public val contactId: Output<String>? = null,
    public val deliveryAddress: Output<ContactChannelDeliveryAddressArgs>? = null,
    public val name: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssmcontacts.ContactChannelArgs> {
    override fun toJava(): com.pulumi.aws.ssmcontacts.ContactChannelArgs =
        com.pulumi.aws.ssmcontacts.ContactChannelArgs.builder()
            .contactId(contactId?.applyValue({ args0 -> args0 }))
            .deliveryAddress(deliveryAddress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactChannelArgs].
 */
@PulumiTagMarker
public class ContactChannelArgsBuilder internal constructor() {
    private var contactId: Output<String>? = null

    private var deliveryAddress: Output<ContactChannelDeliveryAddressArgs>? = null

    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the AWS SSM Contact that the contact channel belongs to.
     */
    @JvmName("wcweejxoaagbwlgw")
    public suspend fun contactId(`value`: Output<String>) {
        this.contactId = value
    }

    /**
     * @param value Block that contains contact engagement details. See details below.
     */
    @JvmName("antuskkfxmfreayl")
    public suspend fun deliveryAddress(`value`: Output<ContactChannelDeliveryAddressArgs>) {
        this.deliveryAddress = value
    }

    /**
     * @param value Name of the contact channel. Must be between 1 and 255 characters, and may contain alphanumerics, underscores (`_`), hyphens (`-`), periods (`.`), and spaces.
     */
    @JvmName("mggjdjhpaplywhaq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Type of the contact channel. One of `SMS`, `VOICE` or `EMAIL`.
     */
    @JvmName("qxtpdajpxhhhnxkq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the AWS SSM Contact that the contact channel belongs to.
     */
    @JvmName("xwufedwxkhfxutqx")
    public suspend fun contactId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactId = mapped
    }

    /**
     * @param value Block that contains contact engagement details. See details below.
     */
    @JvmName("uavkekjruviwcgmh")
    public suspend fun deliveryAddress(`value`: ContactChannelDeliveryAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryAddress = mapped
    }

    /**
     * @param argument Block that contains contact engagement details. See details below.
     */
    @JvmName("kivfwbwnupdsvprq")
    public suspend
    fun deliveryAddress(argument: suspend ContactChannelDeliveryAddressArgsBuilder.() -> Unit) {
        val toBeMapped = ContactChannelDeliveryAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deliveryAddress = mapped
    }

    /**
     * @param value Name of the contact channel. Must be between 1 and 255 characters, and may contain alphanumerics, underscores (`_`), hyphens (`-`), periods (`.`), and spaces.
     */
    @JvmName("hmkjkawlafjwrsnu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Type of the contact channel. One of `SMS`, `VOICE` or `EMAIL`.
     */
    @JvmName("knucjbglypbclcgc")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ContactChannelArgs = ContactChannelArgs(
        contactId = contactId,
        deliveryAddress = deliveryAddress,
        name = name,
        type = type,
    )
}
