@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin

import com.pulumi.aws.ssmcontacts.kotlin.outputs.PlanStage
import com.pulumi.aws.ssmcontacts.kotlin.outputs.PlanStage.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Plan].
 */
@PulumiTagMarker
public class PlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PlanArgs = PlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PlanArgsBuilder.() -> Unit) {
        val builder = PlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Plan {
        val builtJavaResource = com.pulumi.aws.ssmcontacts.Plan(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Plan(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SSM Contact Plan.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmcontacts.Plan;
 * import com.pulumi.aws.ssmcontacts.PlanArgs;
 * import com.pulumi.aws.ssmcontacts.inputs.PlanStageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Plan("example", PlanArgs.builder()
 *             .contactId("arn:aws:ssm-contacts:us-west-2:123456789012:contact/contactalias")
 *             .stages(PlanStageArgs.builder()
 *                 .durationInMinutes(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Usage with SSM Contact
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmcontacts.Contact;
 * import com.pulumi.aws.ssmcontacts.ContactArgs;
 * import com.pulumi.aws.ssmcontacts.Plan;
 * import com.pulumi.aws.ssmcontacts.PlanArgs;
 * import com.pulumi.aws.ssmcontacts.inputs.PlanStageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contact = new Contact("contact", ContactArgs.builder()
 *             .alias("alias")
 *             .type("PERSONAL")
 *             .build());
 *         var plan = new Plan("plan", PlanArgs.builder()
 *             .contactId(contact.arn())
 *             .stages(PlanStageArgs.builder()
 *                 .durationInMinutes(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Usage With All Fields
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmcontacts.Contact;
 * import com.pulumi.aws.ssmcontacts.ContactArgs;
 * import com.pulumi.aws.ssmcontacts.Plan;
 * import com.pulumi.aws.ssmcontacts.PlanArgs;
 * import com.pulumi.aws.ssmcontacts.inputs.PlanStageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var escalationPlan = new Contact("escalationPlan", ContactArgs.builder()
 *             .alias("escalation-plan-alias")
 *             .type("ESCALATION")
 *             .build());
 *         var contactOne = new Contact("contactOne", ContactArgs.builder()
 *             .alias("alias")
 *             .type("PERSONAL")
 *             .build());
 *         var contactTwo = new Contact("contactTwo", ContactArgs.builder()
 *             .alias("alias")
 *             .type("PERSONAL")
 *             .build());
 *         var test = new Plan("test", PlanArgs.builder()
 *             .contactId(escalationPlan.arn())
 *             .stages(PlanStageArgs.builder()
 *                 .durationInMinutes(0)
 *                 .targets(
 *                     PlanStageTargetArgs.builder()
 *                         .contactTargetInfo(PlanStageTargetContactTargetInfoArgs.builder()
 *                             .isEssential(false)
 *                             .contactId(contactOne.arn())
 *                             .build())
 *                         .build(),
 *                     PlanStageTargetArgs.builder()
 *                         .contactTargetInfo(PlanStageTargetContactTargetInfoArgs.builder()
 *                             .isEssential(true)
 *                             .contactId(contactTwo.arn())
 *                             .build())
 *                         .build(),
 *                     PlanStageTargetArgs.builder()
 *                         .channelTargetInfo(PlanStageTargetChannelTargetInfoArgs.builder()
 *                             .retryIntervalInMinutes(2)
 *                             .contactChannelId(aws_ssmcontacts_contact_channel.channel().arn())
 *                             .build())
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSM Contact Plan using the Contact ARN. For example:
 * ```sh
 *  $ pulumi import aws:ssmcontacts/plan:Plan example {ARNValue}
 * ```
 *
 */
public class Plan internal constructor(
    override val javaResource: com.pulumi.aws.ssmcontacts.Plan,
) : KotlinCustomResource(javaResource, PlanMapper) {
    /**
     * The Amazon Resource Name (ARN) of the contact or escalation plan.
     */
    public val contactId: Output<String>
        get() = javaResource.contactId().applyValue({ args0 -> args0 })

    /**
     * One or more configuration blocks for specifying a list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods. See Stage below for more details.
     */
    public val stages: Output<List<PlanStage>>
        get() = javaResource.stages().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })
}

public object PlanMapper : ResourceMapper<Plan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssmcontacts.Plan::class == javaResource::class

    override fun map(javaResource: Resource): Plan = Plan(
        javaResource as
            com.pulumi.aws.ssmcontacts.Plan,
    )
}

/**
 * @see [Plan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Plan].
 */
public suspend fun plan(name: String, block: suspend PlanResourceBuilder.() -> Unit): Plan {
    val builder = PlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Plan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun plan(name: String): Plan {
    val builder = PlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
