@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin

import com.pulumi.aws.ssmcontacts.PlanArgs.builder
import com.pulumi.aws.ssmcontacts.kotlin.inputs.PlanStageArgs
import com.pulumi.aws.ssmcontacts.kotlin.inputs.PlanStageArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SSM Contact Plan.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmcontacts.Plan;
 * import com.pulumi.aws.ssmcontacts.PlanArgs;
 * import com.pulumi.aws.ssmcontacts.inputs.PlanStageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Plan("example", PlanArgs.builder()
 *             .contactId("arn:aws:ssm-contacts:us-west-2:123456789012:contact/contactalias")
 *             .stages(PlanStageArgs.builder()
 *                 .durationInMinutes(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Usage with SSM Contact
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmcontacts.Contact;
 * import com.pulumi.aws.ssmcontacts.ContactArgs;
 * import com.pulumi.aws.ssmcontacts.Plan;
 * import com.pulumi.aws.ssmcontacts.PlanArgs;
 * import com.pulumi.aws.ssmcontacts.inputs.PlanStageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contact = new Contact("contact", ContactArgs.builder()
 *             .alias("alias")
 *             .type("PERSONAL")
 *             .build());
 *         var plan = new Plan("plan", PlanArgs.builder()
 *             .contactId(contact.arn())
 *             .stages(PlanStageArgs.builder()
 *                 .durationInMinutes(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Usage With All Fields
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmcontacts.Contact;
 * import com.pulumi.aws.ssmcontacts.ContactArgs;
 * import com.pulumi.aws.ssmcontacts.Plan;
 * import com.pulumi.aws.ssmcontacts.PlanArgs;
 * import com.pulumi.aws.ssmcontacts.inputs.PlanStageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var escalationPlan = new Contact("escalationPlan", ContactArgs.builder()
 *             .alias("escalation-plan-alias")
 *             .type("ESCALATION")
 *             .build());
 *         var contactOne = new Contact("contactOne", ContactArgs.builder()
 *             .alias("alias")
 *             .type("PERSONAL")
 *             .build());
 *         var contactTwo = new Contact("contactTwo", ContactArgs.builder()
 *             .alias("alias")
 *             .type("PERSONAL")
 *             .build());
 *         var test = new Plan("test", PlanArgs.builder()
 *             .contactId(escalationPlan.arn())
 *             .stages(PlanStageArgs.builder()
 *                 .durationInMinutes(0)
 *                 .targets(
 *                     PlanStageTargetArgs.builder()
 *                         .contactTargetInfo(PlanStageTargetContactTargetInfoArgs.builder()
 *                             .isEssential(false)
 *                             .contactId(contactOne.arn())
 *                             .build())
 *                         .build(),
 *                     PlanStageTargetArgs.builder()
 *                         .contactTargetInfo(PlanStageTargetContactTargetInfoArgs.builder()
 *                             .isEssential(true)
 *                             .contactId(contactTwo.arn())
 *                             .build())
 *                         .build(),
 *                     PlanStageTargetArgs.builder()
 *                         .channelTargetInfo(PlanStageTargetChannelTargetInfoArgs.builder()
 *                             .retryIntervalInMinutes(2)
 *                             .contactChannelId(aws_ssmcontacts_contact_channel.channel().arn())
 *                             .build())
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSM Contact Plan using the Contact ARN. For example:
 * ```sh
 *  $ pulumi import aws:ssmcontacts/plan:Plan example {ARNValue}
 * ```
 * @property contactId The Amazon Resource Name (ARN) of the contact or escalation plan.
 * @property stages One or more configuration blocks for specifying a list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods. See Stage below for more details.
 */
public data class PlanArgs(
    public val contactId: Output<String>? = null,
    public val stages: Output<List<PlanStageArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssmcontacts.PlanArgs> {
    override fun toJava(): com.pulumi.aws.ssmcontacts.PlanArgs =
        com.pulumi.aws.ssmcontacts.PlanArgs.builder()
            .contactId(contactId?.applyValue({ args0 -> args0 }))
            .stages(
                stages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PlanArgs].
 */
@PulumiTagMarker
public class PlanArgsBuilder internal constructor() {
    private var contactId: Output<String>? = null

    private var stages: Output<List<PlanStageArgs>>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the contact or escalation plan.
     */
    @JvmName("polsdbungddapxwm")
    public suspend fun contactId(`value`: Output<String>) {
        this.contactId = value
    }

    /**
     * @param value One or more configuration blocks for specifying a list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods. See Stage below for more details.
     */
    @JvmName("oclacxfvkenextvn")
    public suspend fun stages(`value`: Output<List<PlanStageArgs>>) {
        this.stages = value
    }

    @JvmName("ricjvjwunrqxhcyg")
    public suspend fun stages(vararg values: Output<PlanStageArgs>) {
        this.stages = Output.all(values.asList())
    }

    /**
     * @param values One or more configuration blocks for specifying a list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods. See Stage below for more details.
     */
    @JvmName("ogacqqbfnrvcmcqx")
    public suspend fun stages(values: List<Output<PlanStageArgs>>) {
        this.stages = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the contact or escalation plan.
     */
    @JvmName("hflgiiabvifhfsoe")
    public suspend fun contactId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactId = mapped
    }

    /**
     * @param value One or more configuration blocks for specifying a list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods. See Stage below for more details.
     */
    @JvmName("kgyoppgmkdqxpfvo")
    public suspend fun stages(`value`: List<PlanStageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stages = mapped
    }

    /**
     * @param argument One or more configuration blocks for specifying a list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods. See Stage below for more details.
     */
    @JvmName("lgjupucfoakonnqx")
    public suspend fun stages(argument: List<suspend PlanStageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PlanStageArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.stages = mapped
    }

    /**
     * @param argument One or more configuration blocks for specifying a list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods. See Stage below for more details.
     */
    @JvmName("dnydhtqqemishsfl")
    public suspend fun stages(vararg argument: suspend PlanStageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PlanStageArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.stages = mapped
    }

    /**
     * @param argument One or more configuration blocks for specifying a list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods. See Stage below for more details.
     */
    @JvmName("bmrpugkwinlbkkas")
    public suspend fun stages(argument: suspend PlanStageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PlanStageArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.stages = mapped
    }

    /**
     * @param values One or more configuration blocks for specifying a list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods. See Stage below for more details.
     */
    @JvmName("uykbgnqfsnxfjfua")
    public suspend fun stages(vararg values: PlanStageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stages = mapped
    }

    internal fun build(): PlanArgs = PlanArgs(
        contactId = contactId,
        stages = stages,
    )
}
