@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin

import com.pulumi.aws.ssmcontacts.SsmcontactsFunctions.getContactChannelPlain
import com.pulumi.aws.ssmcontacts.SsmcontactsFunctions.getContactPlain
import com.pulumi.aws.ssmcontacts.SsmcontactsFunctions.getPlanPlain
import com.pulumi.aws.ssmcontacts.kotlin.inputs.GetContactChannelPlainArgs
import com.pulumi.aws.ssmcontacts.kotlin.inputs.GetContactChannelPlainArgsBuilder
import com.pulumi.aws.ssmcontacts.kotlin.inputs.GetContactPlainArgs
import com.pulumi.aws.ssmcontacts.kotlin.inputs.GetContactPlainArgsBuilder
import com.pulumi.aws.ssmcontacts.kotlin.inputs.GetPlanPlainArgs
import com.pulumi.aws.ssmcontacts.kotlin.inputs.GetPlanPlainArgsBuilder
import com.pulumi.aws.ssmcontacts.kotlin.outputs.GetContactChannelResult
import com.pulumi.aws.ssmcontacts.kotlin.outputs.GetContactResult
import com.pulumi.aws.ssmcontacts.kotlin.outputs.GetPlanResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.ssmcontacts.kotlin.outputs.GetContactChannelResult.Companion.toKotlin as getContactChannelResultToKotlin
import com.pulumi.aws.ssmcontacts.kotlin.outputs.GetContactResult.Companion.toKotlin as getContactResultToKotlin
import com.pulumi.aws.ssmcontacts.kotlin.outputs.GetPlanResult.Companion.toKotlin as getPlanResultToKotlin

public object SsmcontactsFunctions {
    /**
     * Data source for managing an AWS SSM Contact.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssmcontacts.SsmcontactsFunctions;
     * import com.pulumi.aws.ssmcontacts.inputs.GetContactArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsmcontactsFunctions.getContact(GetContactArgs.builder()
     *             .arn("arn:aws:ssm-contacts:us-west-2:123456789012:contact/contactalias")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getContact.
     * @return A collection of values returned by getContact.
     */
    public suspend fun getContact(argument: GetContactPlainArgs): GetContactResult =
        getContactResultToKotlin(getContactPlain(argument.toJava()).await())

    /**
     * @see [getContact].
     * @param arn The Amazon Resource Name (ARN) of the contact or escalation plan.
     * @param tags Map of tags to assign to the resource.
     * @return A collection of values returned by getContact.
     */
    public suspend fun getContact(arn: String, tags: Map<String, String>? = null): GetContactResult {
        val argument = GetContactPlainArgs(
            arn = arn,
            tags = tags,
        )
        return getContactResultToKotlin(getContactPlain(argument.toJava()).await())
    }

    /**
     * @see [getContact].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssmcontacts&#46;kotlin&#46;inputs&#46;GetContactPlainArgs].
     * @return A collection of values returned by getContact.
     */
    public suspend fun getContact(argument: suspend GetContactPlainArgsBuilder.() -> Unit):
        GetContactResult {
        val builder = GetContactPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContactResultToKotlin(getContactPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS SSM Contacts Contact Channel.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssmcontacts.SsmcontactsFunctions;
     * import com.pulumi.aws.ssmcontacts.inputs.GetContactChannelArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsmcontactsFunctions.getContactChannel(GetContactChannelArgs.builder()
     *             .arn("arn:aws:ssm-contacts:us-west-2:123456789012:contact-channel/example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getContactChannel.
     * @return A collection of values returned by getContactChannel.
     */
    public suspend fun getContactChannel(argument: GetContactChannelPlainArgs):
        GetContactChannelResult =
        getContactChannelResultToKotlin(getContactChannelPlain(argument.toJava()).await())

    /**
     * @see [getContactChannel].
     * @param arn Amazon Resource Name (ARN) of the contact channel.
     * @return A collection of values returned by getContactChannel.
     */
    public suspend fun getContactChannel(arn: String): GetContactChannelResult {
        val argument = GetContactChannelPlainArgs(
            arn = arn,
        )
        return getContactChannelResultToKotlin(getContactChannelPlain(argument.toJava()).await())
    }

    /**
     * @see [getContactChannel].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssmcontacts&#46;kotlin&#46;inputs&#46;GetContactChannelPlainArgs].
     * @return A collection of values returned by getContactChannel.
     */
    public suspend
    fun getContactChannel(argument: suspend GetContactChannelPlainArgsBuilder.() -> Unit):
        GetContactChannelResult {
        val builder = GetContactChannelPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getContactChannelResultToKotlin(getContactChannelPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing a Plan of an AWS SSM Contact.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssmcontacts.SsmcontactsFunctions;
     * import com.pulumi.aws.ssmcontacts.inputs.GetPlanArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = SsmcontactsFunctions.getPlan(GetPlanArgs.builder()
     *             .contactId("arn:aws:ssm-contacts:us-west-2:123456789012:contact/contactalias")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getPlan.
     * @return A collection of values returned by getPlan.
     */
    public suspend fun getPlan(argument: GetPlanPlainArgs): GetPlanResult =
        getPlanResultToKotlin(getPlanPlain(argument.toJava()).await())

    /**
     * @see [getPlan].
     * @param contactId The Amazon Resource Name (ARN) of the contact or escalation plan.
     * @return A collection of values returned by getPlan.
     */
    public suspend fun getPlan(contactId: String): GetPlanResult {
        val argument = GetPlanPlainArgs(
            contactId = contactId,
        )
        return getPlanResultToKotlin(getPlanPlain(argument.toJava()).await())
    }

    /**
     * @see [getPlan].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssmcontacts&#46;kotlin&#46;inputs&#46;GetPlanPlainArgs].
     * @return A collection of values returned by getPlan.
     */
    public suspend fun getPlan(argument: suspend GetPlanPlainArgsBuilder.() -> Unit): GetPlanResult {
        val builder = GetPlanPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPlanResultToKotlin(getPlanPlain(builtArgument.toJava()).await())
    }
}
