@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin.inputs

import com.pulumi.aws.ssmcontacts.inputs.ContactChannelDeliveryAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property simpleAddress Details to engage this contact channel. The expected format depends on the contact channel type and is described in the [`ContactChannelAddress` section of the SSM Contacts API Reference](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ContactChannelAddress.html).
 */
public data class ContactChannelDeliveryAddressArgs(
    public val simpleAddress: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ssmcontacts.inputs.ContactChannelDeliveryAddressArgs> {
    override fun toJava(): com.pulumi.aws.ssmcontacts.inputs.ContactChannelDeliveryAddressArgs =
        com.pulumi.aws.ssmcontacts.inputs.ContactChannelDeliveryAddressArgs.builder()
            .simpleAddress(simpleAddress.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactChannelDeliveryAddressArgs].
 */
@PulumiTagMarker
public class ContactChannelDeliveryAddressArgsBuilder internal constructor() {
    private var simpleAddress: Output<String>? = null

    /**
     * @param value Details to engage this contact channel. The expected format depends on the contact channel type and is described in the [`ContactChannelAddress` section of the SSM Contacts API Reference](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ContactChannelAddress.html).
     */
    @JvmName("vbtcbdiqpnlvauvn")
    public suspend fun simpleAddress(`value`: Output<String>) {
        this.simpleAddress = value
    }

    /**
     * @param value Details to engage this contact channel. The expected format depends on the contact channel type and is described in the [`ContactChannelAddress` section of the SSM Contacts API Reference](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ContactChannelAddress.html).
     */
    @JvmName("fjolvirodphnmmio")
    public suspend fun simpleAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.simpleAddress = mapped
    }

    internal fun build(): ContactChannelDeliveryAddressArgs = ContactChannelDeliveryAddressArgs(
        simpleAddress = simpleAddress ?: throw PulumiNullFieldException("simpleAddress"),
    )
}
