@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin.inputs

import com.pulumi.aws.ssmcontacts.inputs.GetPlanPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPlan.
 * @property contactId The Amazon Resource Name (ARN) of the contact or escalation plan.
 */
public data class GetPlanPlainArgs(
    public val contactId: String,
) : ConvertibleToJava<com.pulumi.aws.ssmcontacts.inputs.GetPlanPlainArgs> {
    override fun toJava(): com.pulumi.aws.ssmcontacts.inputs.GetPlanPlainArgs =
        com.pulumi.aws.ssmcontacts.inputs.GetPlanPlainArgs.builder()
            .contactId(contactId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPlanPlainArgs].
 */
@PulumiTagMarker
public class GetPlanPlainArgsBuilder internal constructor() {
    private var contactId: String? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the contact or escalation plan.
     */
    @JvmName("ujhbytfpodhaoepv")
    public suspend fun contactId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.contactId = mapped
    }

    internal fun build(): GetPlanPlainArgs = GetPlanPlainArgs(
        contactId = contactId ?: throw PulumiNullFieldException("contactId"),
    )
}
