@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin.inputs

import com.pulumi.aws.ssmcontacts.inputs.PlanStageTargetChannelTargetInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property contactChannelId The Amazon Resource Name (ARN) of the contact channel.
 * @property retryIntervalInMinutes The number of minutes to wait before retrying to send engagement if the engagement initially failed.
 */
public data class PlanStageTargetChannelTargetInfoArgs(
    public val contactChannelId: Output<String>,
    public val retryIntervalInMinutes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssmcontacts.inputs.PlanStageTargetChannelTargetInfoArgs> {
    override fun toJava(): com.pulumi.aws.ssmcontacts.inputs.PlanStageTargetChannelTargetInfoArgs =
        com.pulumi.aws.ssmcontacts.inputs.PlanStageTargetChannelTargetInfoArgs.builder()
            .contactChannelId(contactChannelId.applyValue({ args0 -> args0 }))
            .retryIntervalInMinutes(retryIntervalInMinutes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlanStageTargetChannelTargetInfoArgs].
 */
@PulumiTagMarker
public class PlanStageTargetChannelTargetInfoArgsBuilder internal constructor() {
    private var contactChannelId: Output<String>? = null

    private var retryIntervalInMinutes: Output<Int>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the contact channel.
     */
    @JvmName("wsttkyhrfdvboumu")
    public suspend fun contactChannelId(`value`: Output<String>) {
        this.contactChannelId = value
    }

    /**
     * @param value The number of minutes to wait before retrying to send engagement if the engagement initially failed.
     */
    @JvmName("ahmvrdyxvdcxnhiw")
    public suspend fun retryIntervalInMinutes(`value`: Output<Int>) {
        this.retryIntervalInMinutes = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the contact channel.
     */
    @JvmName("nqxwptrtbhvanpgg")
    public suspend fun contactChannelId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactChannelId = mapped
    }

    /**
     * @param value The number of minutes to wait before retrying to send engagement if the engagement initially failed.
     */
    @JvmName("hmjieoeqxvkijmns")
    public suspend fun retryIntervalInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryIntervalInMinutes = mapped
    }

    internal fun build(): PlanStageTargetChannelTargetInfoArgs = PlanStageTargetChannelTargetInfoArgs(
        contactChannelId = contactChannelId ?: throw PulumiNullFieldException("contactChannelId"),
        retryIntervalInMinutes = retryIntervalInMinutes,
    )
}
