@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property simpleAddress Details to engage this contact channel. The expected format depends on the contact channel type and is described in the [`ContactChannelAddress` section of the SSM Contacts API Reference](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_SSMContacts_ContactChannelAddress.html).
 */
public data class ContactChannelDeliveryAddress(
    public val simpleAddress: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssmcontacts.outputs.ContactChannelDeliveryAddress):
            ContactChannelDeliveryAddress = ContactChannelDeliveryAddress(
            simpleAddress = javaType.simpleAddress(),
        )
    }
}
