@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getContact.
 * @property alias A unique and identifiable alias of the contact or escalation plan.
 * @property arn
 * @property displayName Full friendly name of the contact or escalation plan.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property tags Map of tags to assign to the resource.
 * @property type The type of contact engaged. A single contact is type `PERSONAL` and an escalation plan is type `ESCALATION`.
 */
public data class GetContactResult(
    public val alias: String,
    public val arn: String,
    public val displayName: String,
    public val id: String,
    public val tags: Map<String, String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssmcontacts.outputs.GetContactResult):
            GetContactResult = GetContactResult(
            alias = javaType.alias(),
            arn = javaType.arn(),
            displayName = javaType.displayName(),
            id = javaType.id(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
