@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property durationInMinutes The time to wait until beginning the next stage. The duration can only be set to 0 if a target is specified.
 * @property targets One or more configuration blocks for specifying the contacts or contact methods that the escalation plan or engagement plan is engaging. See Target below for more details.
 */
public data class PlanStage(
    public val durationInMinutes: Int,
    public val targets: List<PlanStageTarget>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssmcontacts.outputs.PlanStage): PlanStage =
            PlanStage(
                durationInMinutes = javaType.durationInMinutes(),
                targets = javaType.targets().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ssmcontacts.kotlin.outputs.PlanStageTarget.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
