@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property channelTargetInfo A configuration block for specifying information about the contact channel that Incident Manager engages. See Channel Target Info for more details.
 * @property contactTargetInfo A configuration block for specifying information about the contact that Incident Manager engages. See Contact Target Info for more details.
 */
public data class PlanStageTarget(
    public val channelTargetInfo: PlanStageTargetChannelTargetInfo? = null,
    public val contactTargetInfo: PlanStageTargetContactTargetInfo? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssmcontacts.outputs.PlanStageTarget):
            PlanStageTarget = PlanStageTarget(
            channelTargetInfo = javaType.channelTargetInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssmcontacts.kotlin.outputs.PlanStageTargetChannelTargetInfo.Companion.toKotlin(args0)
                })
            }).orElse(null),
            contactTargetInfo = javaType.contactTargetInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssmcontacts.kotlin.outputs.PlanStageTargetContactTargetInfo.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
