@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property contactChannelId The Amazon Resource Name (ARN) of the contact channel.
 * @property retryIntervalInMinutes The number of minutes to wait before retrying to send engagement if the engagement initially failed.
 */
public data class PlanStageTargetChannelTargetInfo(
    public val contactChannelId: String,
    public val retryIntervalInMinutes: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ssmcontacts.outputs.PlanStageTargetChannelTargetInfo):
            PlanStageTargetChannelTargetInfo = PlanStageTargetChannelTargetInfo(
            contactChannelId = javaType.contactChannelId(),
            retryIntervalInMinutes = javaType.retryIntervalInMinutes().map({ args0 -> args0 }).orElse(null),
        )
    }
}
