@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmcontacts.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property contactId The Amazon Resource Name (ARN) of the contact.
 * @property isEssential A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
 */
public data class PlanStageTargetContactTargetInfo(
    public val contactId: String? = null,
    public val isEssential: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ssmcontacts.outputs.PlanStageTargetContactTargetInfo):
            PlanStageTargetContactTargetInfo = PlanStageTargetContactTargetInfo(
            contactId = javaType.contactId().map({ args0 -> args0 }).orElse(null),
            isEssential = javaType.isEssential(),
        )
    }
}
