@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin

import com.pulumi.aws.ssmincidents.ReplicationSetArgs.builder
import com.pulumi.aws.ssmincidents.kotlin.inputs.ReplicationSetRegionArgs
import com.pulumi.aws.ssmincidents.kotlin.inputs.ReplicationSetRegionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource for managing a replication set in AWS Systems Manager Incident Manager.
 * > **NOTE:** Deleting a replication set also deletes all Incident Manager related data including response plans, incident records, contacts and escalation plans.
 * ## Example Usage
 * ### Basic Usage
 * Create a replication set.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmincidents.ReplicationSet;
 * import com.pulumi.aws.ssmincidents.ReplicationSetArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ReplicationSetRegionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationSetName = new ReplicationSet("replicationSetName", ReplicationSetArgs.builder()
 *             .regions(ReplicationSetRegionArgs.builder()
 *                 .name("us-west-2")
 *                 .build())
 *             .tags(Map.of("exampleTag", "exampleValue"))
 *             .build());
 *     }
 * }
 * ```
 * ## Basic Usage with an AWS Customer Managed Key
 * Create a replication set with an AWS Key Management Service (AWS KMS) customer manager key:
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleKey = new aws.kms.Key("exampleKey", {});
 * const replicationSetName = new aws.ssmincidents.ReplicationSet("replicationSetName", {
 *     regions: [{
 *         name: "us-west-2",
 *         kmsKeyArn: exampleKey.arn,
 *     }],
 *     tags: {
 *         exampleTag: "exampleValue",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_key = aws.kms.Key("exampleKey")
 * replication_set_name = aws.ssmincidents.ReplicationSet("replicationSetName",
 *     regions=[aws.ssmincidents.ReplicationSetRegionArgs(
 *         name="us-west-2",
 *         kms_key_arn=example_key.arn,
 *     )],
 *     tags={
 *         "exampleTag": "exampleValue",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleKey = new Aws.Kms.Key("exampleKey");
 *     var replicationSetName = new Aws.SsmIncidents.ReplicationSet("replicationSetName", new()
 *     {
 *         Regions = new[]
 *         {
 *             new Aws.SsmIncidents.Inputs.ReplicationSetRegionArgs
 *             {
 *                 Name = "us-west-2",
 *                 KmsKeyArn = exampleKey.Arn,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "exampleTag", "exampleValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssmincidents"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleKey, err := kms.NewKey(ctx, "exampleKey", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssmincidents.NewReplicationSet(ctx, "replicationSetName", &ssmincidents.ReplicationSetArgs{
 * 			Regions: ssmincidents.ReplicationSetRegionArray{
 * 				&ssmincidents.ReplicationSetRegionArgs{
 * 					Name:      pulumi.String("us-west-2"),
 * 					KmsKeyArn: exampleKey.Arn,
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"exampleTag": pulumi.String("exampleValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.ssmincidents.ReplicationSet;
 * import com.pulumi.aws.ssmincidents.ReplicationSetArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ReplicationSetRegionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey");
 *         var replicationSetName = new ReplicationSet("replicationSetName", ReplicationSetArgs.builder()
 *             .regions(ReplicationSetRegionArgs.builder()
 *                 .name("us-west-2")
 *                 .kmsKeyArn(exampleKey.arn())
 *                 .build())
 *             .tags(Map.of("exampleTag", "exampleValue"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleKey:
 *     type: aws:kms:Key
 *   replicationSetName:
 *     type: aws:ssmincidents:ReplicationSet
 *     properties:
 *       regions:
 *         - name: us-west-2
 *           kmsKeyArn: ${exampleKey.arn}
 *       tags:
 *         exampleTag: exampleValue
 * ```
 * ## Import
 * Using `pulumi import`, import an Incident Manager replication. For example:
 * ```sh
 *  $ pulumi import aws:ssmincidents/replicationSet:ReplicationSet replicationSetName import
 * ```
 * @property regions
 * @property tags Tags applied to the replication set.
 * For information about the maximum allowed number of Regions and tag value constraints, see [CreateReplicationSet in the *AWS Systems Manager Incident Manager API Reference*](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateReplicationSet.html).
 */
public data class ReplicationSetArgs(
    public val regions: Output<List<ReplicationSetRegionArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssmincidents.ReplicationSetArgs> {
    override fun toJava(): com.pulumi.aws.ssmincidents.ReplicationSetArgs =
        com.pulumi.aws.ssmincidents.ReplicationSetArgs.builder()
            .regions(
                regions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ReplicationSetArgs].
 */
@PulumiTagMarker
public class ReplicationSetArgsBuilder internal constructor() {
    private var regions: Output<List<ReplicationSetRegionArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("ahjoqelelpptrtxx")
    public suspend fun regions(`value`: Output<List<ReplicationSetRegionArgs>>) {
        this.regions = value
    }

    @JvmName("urahtuylwhyfcwhe")
    public suspend fun regions(vararg values: Output<ReplicationSetRegionArgs>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("irldhhusvuwlosfy")
    public suspend fun regions(values: List<Output<ReplicationSetRegionArgs>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value Tags applied to the replication set.
     * For information about the maximum allowed number of Regions and tag value constraints, see [CreateReplicationSet in the *AWS Systems Manager Incident Manager API Reference*](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateReplicationSet.html).
     */
    @JvmName("rcqkucxbpwxhwrvv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("mtmqyfawnxjrvrgj")
    public suspend fun regions(`value`: List<ReplicationSetRegionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wgcphvongfarkkan")
    public suspend fun regions(argument: List<suspend ReplicationSetRegionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ReplicationSetRegionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hithmxrpdsxhijwo")
    public suspend fun regions(vararg argument: suspend ReplicationSetRegionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ReplicationSetRegionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tononqajpjqiqcdo")
    public suspend fun regions(argument: suspend ReplicationSetRegionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ReplicationSetRegionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.regions = mapped
    }

    /**
     * @param values
     */
    @JvmName("rnppwfgjaoijceld")
    public suspend fun regions(vararg values: ReplicationSetRegionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param value Tags applied to the replication set.
     * For information about the maximum allowed number of Regions and tag value constraints, see [CreateReplicationSet in the *AWS Systems Manager Incident Manager API Reference*](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateReplicationSet.html).
     */
    @JvmName("kntyglsrlaqbtjrx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags applied to the replication set.
     * For information about the maximum allowed number of Regions and tag value constraints, see [CreateReplicationSet in the *AWS Systems Manager Incident Manager API Reference*](https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateReplicationSet.html).
     */
    @JvmName("xwlcsagjvagmujir")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ReplicationSetArgs = ReplicationSetArgs(
        regions = regions,
        tags = tags,
    )
}
