@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin

import com.pulumi.aws.ssmincidents.kotlin.outputs.ResponsePlanAction
import com.pulumi.aws.ssmincidents.kotlin.outputs.ResponsePlanIncidentTemplate
import com.pulumi.aws.ssmincidents.kotlin.outputs.ResponsePlanIntegration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ssmincidents.kotlin.outputs.ResponsePlanAction.Companion.toKotlin as responsePlanActionToKotlin
import com.pulumi.aws.ssmincidents.kotlin.outputs.ResponsePlanIncidentTemplate.Companion.toKotlin as responsePlanIncidentTemplateToKotlin
import com.pulumi.aws.ssmincidents.kotlin.outputs.ResponsePlanIntegration.Companion.toKotlin as responsePlanIntegrationToKotlin

/**
 * Builder for [ResponsePlan].
 */
@PulumiTagMarker
public class ResponsePlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResponsePlanArgs = ResponsePlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResponsePlanArgsBuilder.() -> Unit) {
        val builder = ResponsePlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ResponsePlan {
        val builtJavaResource = com.pulumi.aws.ssmincidents.ResponsePlan(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResponsePlan(builtJavaResource)
    }
}

/**
 * Provides a resource to manage response plans in AWS Systems Manager Incident Manager.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmincidents.ResponsePlan;
 * import com.pulumi.aws.ssmincidents.ResponsePlanArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ResponsePlanIncidentTemplateArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResponsePlan("example", ResponsePlanArgs.builder()
 *             .incidentTemplate(ResponsePlanIncidentTemplateArgs.builder()
 *                 .title("title")
 *                 .impact("3")
 *                 .build())
 *             .tags(Map.of("key", "value"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_ssmincidents_replication_set.example())
 *                 .build());
 *     }
 * }
 * ```
 * ### Usage With All Fields
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmincidents.ResponsePlan;
 * import com.pulumi.aws.ssmincidents.ResponsePlanArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ResponsePlanIncidentTemplateArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ResponsePlanActionArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ResponsePlanIntegrationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResponsePlan("example", ResponsePlanArgs.builder()
 *             .incidentTemplate(ResponsePlanIncidentTemplateArgs.builder()
 *                 .title("title")
 *                 .impact("3")
 *                 .dedupeString("dedupe")
 *                 .incidentTags(Map.of("key", "value"))
 *                 .notificationTargets(
 *                     ResponsePlanIncidentTemplateNotificationTargetArgs.builder()
 *                         .snsTopicArn(aws_sns_topic.example1().arn())
 *                         .build(),
 *                     ResponsePlanIncidentTemplateNotificationTargetArgs.builder()
 *                         .snsTopicArn(aws_sns_topic.example2().arn())
 *                         .build())
 *                 .summary("summary")
 *                 .build())
 *             .displayName("display name")
 *             .chatChannels(aws_sns_topic.topic().arn())
 *             .engagements("arn:aws:ssm-contacts:us-east-2:111122223333:contact/test1")
 *             .action(ResponsePlanActionArgs.builder()
 *                 .ssmAutomations(ResponsePlanActionSsmAutomationArgs.builder()
 *                     .documentName(aws_ssm_document.document1().name())
 *                     .roleArn(aws_iam_role.role1().arn())
 *                     .documentVersion("version1")
 *                     .targetAccount("RESPONSE_PLAN_OWNER_ACCOUNT")
 *                     .parameters(
 *                         ResponsePlanActionSsmAutomationParameterArgs.builder()
 *                             .name("key")
 *                             .values(
 *                                 "value1",
 *                                 "value2")
 *                             .build(),
 *                         ResponsePlanActionSsmAutomationParameterArgs.builder()
 *                             .name("foo")
 *                             .values("bar")
 *                             .build())
 *                     .dynamicParameters(Map.ofEntries(
 *                         Map.entry("someKey", "INVOLVED_RESOURCES"),
 *                         Map.entry("anotherKey", "INCIDENT_RECORD_ARN")
 *                     ))
 *                     .build())
 *                 .build())
 *             .integration(ResponsePlanIntegrationArgs.builder()
 *                 .pagerduties(ResponsePlanIntegrationPagerdutyArgs.builder()
 *                     .name("pagerdutyIntergration")
 *                     .serviceId("example")
 *                     .secretId("example")
 *                     .build())
 *                 .build())
 *             .tags(Map.of("key", "value"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_ssmincidents_replication_set.example())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import an Incident Manager response plan using the response plan ARN. You can find the response plan ARN in the AWS Management Console. For example:
 * ```sh
 *  $ pulumi import aws:ssmincidents/responsePlan:ResponsePlan responsePlanName ARNValue
 * ```
 *
 */
public class ResponsePlan internal constructor(
    override val javaResource: com.pulumi.aws.ssmincidents.ResponsePlan,
) : KotlinCustomResource(javaResource, ResponsePlanMapper) {
    /**
     * The actions that the response plan starts at the beginning of an incident.
     */
    public val action: Output<ResponsePlanAction>?
        get() = javaResource.action().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    responsePlanActionToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ARN of the response plan.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Chatbot chat channel used for collaboration during an incident.
     */
    public val chatChannels: Output<List<String>>?
        get() = javaResource.chatChannels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The long format of the response plan name. This field can contain spaces.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an incident.
     */
    public val engagements: Output<List<String>>?
        get() = javaResource.engagements().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    public val incidentTemplate: Output<ResponsePlanIncidentTemplate>
        get() = javaResource.incidentTemplate().applyValue({ args0 ->
            args0.let({ args0 ->
                responsePlanIncidentTemplateToKotlin(args0)
            })
        })

    /**
     * Information about third-party services integrated into the response plan. The following values are supported:
     */
    public val integration: Output<ResponsePlanIntegration>?
        get() = javaResource.integration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    responsePlanIntegrationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the response plan.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The tags applied to the response plan.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ResponsePlanMapper : ResourceMapper<ResponsePlan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssmincidents.ResponsePlan::class == javaResource::class

    override fun map(javaResource: Resource): ResponsePlan = ResponsePlan(
        javaResource as
            com.pulumi.aws.ssmincidents.ResponsePlan,
    )
}

/**
 * @see [ResponsePlan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResponsePlan].
 */
public suspend fun responsePlan(
    name: String,
    block: suspend ResponsePlanResourceBuilder.() -> Unit,
): ResponsePlan {
    val builder = ResponsePlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResponsePlan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun responsePlan(name: String): ResponsePlan {
    val builder = ResponsePlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
