@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin

import com.pulumi.aws.ssmincidents.ResponsePlanArgs.builder
import com.pulumi.aws.ssmincidents.kotlin.inputs.ResponsePlanActionArgs
import com.pulumi.aws.ssmincidents.kotlin.inputs.ResponsePlanActionArgsBuilder
import com.pulumi.aws.ssmincidents.kotlin.inputs.ResponsePlanIncidentTemplateArgs
import com.pulumi.aws.ssmincidents.kotlin.inputs.ResponsePlanIncidentTemplateArgsBuilder
import com.pulumi.aws.ssmincidents.kotlin.inputs.ResponsePlanIntegrationArgs
import com.pulumi.aws.ssmincidents.kotlin.inputs.ResponsePlanIntegrationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage response plans in AWS Systems Manager Incident Manager.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmincidents.ResponsePlan;
 * import com.pulumi.aws.ssmincidents.ResponsePlanArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ResponsePlanIncidentTemplateArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResponsePlan("example", ResponsePlanArgs.builder()
 *             .incidentTemplate(ResponsePlanIncidentTemplateArgs.builder()
 *                 .title("title")
 *                 .impact("3")
 *                 .build())
 *             .tags(Map.of("key", "value"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_ssmincidents_replication_set.example())
 *                 .build());
 *     }
 * }
 * ```
 * ### Usage With All Fields
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssmincidents.ResponsePlan;
 * import com.pulumi.aws.ssmincidents.ResponsePlanArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ResponsePlanIncidentTemplateArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ResponsePlanActionArgs;
 * import com.pulumi.aws.ssmincidents.inputs.ResponsePlanIntegrationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResponsePlan("example", ResponsePlanArgs.builder()
 *             .incidentTemplate(ResponsePlanIncidentTemplateArgs.builder()
 *                 .title("title")
 *                 .impact("3")
 *                 .dedupeString("dedupe")
 *                 .incidentTags(Map.of("key", "value"))
 *                 .notificationTargets(
 *                     ResponsePlanIncidentTemplateNotificationTargetArgs.builder()
 *                         .snsTopicArn(aws_sns_topic.example1().arn())
 *                         .build(),
 *                     ResponsePlanIncidentTemplateNotificationTargetArgs.builder()
 *                         .snsTopicArn(aws_sns_topic.example2().arn())
 *                         .build())
 *                 .summary("summary")
 *                 .build())
 *             .displayName("display name")
 *             .chatChannels(aws_sns_topic.topic().arn())
 *             .engagements("arn:aws:ssm-contacts:us-east-2:111122223333:contact/test1")
 *             .action(ResponsePlanActionArgs.builder()
 *                 .ssmAutomations(ResponsePlanActionSsmAutomationArgs.builder()
 *                     .documentName(aws_ssm_document.document1().name())
 *                     .roleArn(aws_iam_role.role1().arn())
 *                     .documentVersion("version1")
 *                     .targetAccount("RESPONSE_PLAN_OWNER_ACCOUNT")
 *                     .parameters(
 *                         ResponsePlanActionSsmAutomationParameterArgs.builder()
 *                             .name("key")
 *                             .values(
 *                                 "value1",
 *                                 "value2")
 *                             .build(),
 *                         ResponsePlanActionSsmAutomationParameterArgs.builder()
 *                             .name("foo")
 *                             .values("bar")
 *                             .build())
 *                     .dynamicParameters(Map.ofEntries(
 *                         Map.entry("someKey", "INVOLVED_RESOURCES"),
 *                         Map.entry("anotherKey", "INCIDENT_RECORD_ARN")
 *                     ))
 *                     .build())
 *                 .build())
 *             .integration(ResponsePlanIntegrationArgs.builder()
 *                 .pagerduties(ResponsePlanIntegrationPagerdutyArgs.builder()
 *                     .name("pagerdutyIntergration")
 *                     .serviceId("example")
 *                     .secretId("example")
 *                     .build())
 *                 .build())
 *             .tags(Map.of("key", "value"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_ssmincidents_replication_set.example())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import an Incident Manager response plan using the response plan ARN. You can find the response plan ARN in the AWS Management Console. For example:
 * ```sh
 *  $ pulumi import aws:ssmincidents/responsePlan:ResponsePlan responsePlanName ARNValue
 * ```
 * @property action The actions that the response plan starts at the beginning of an incident.
 * @property chatChannels The Chatbot chat channel used for collaboration during an incident.
 * @property displayName The long format of the response plan name. This field can contain spaces.
 * @property engagements The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an incident.
 * @property incidentTemplate
 * @property integration Information about third-party services integrated into the response plan. The following values are supported:
 * @property name The name of the response plan.
 * @property tags The tags applied to the response plan.
 */
public data class ResponsePlanArgs(
    public val action: Output<ResponsePlanActionArgs>? = null,
    public val chatChannels: Output<List<String>>? = null,
    public val displayName: Output<String>? = null,
    public val engagements: Output<List<String>>? = null,
    public val incidentTemplate: Output<ResponsePlanIncidentTemplateArgs>? = null,
    public val integration: Output<ResponsePlanIntegrationArgs>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssmincidents.ResponsePlanArgs> {
    override fun toJava(): com.pulumi.aws.ssmincidents.ResponsePlanArgs =
        com.pulumi.aws.ssmincidents.ResponsePlanArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .chatChannels(chatChannels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .engagements(engagements?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .incidentTemplate(incidentTemplate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .integration(integration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResponsePlanArgs].
 */
@PulumiTagMarker
public class ResponsePlanArgsBuilder internal constructor() {
    private var action: Output<ResponsePlanActionArgs>? = null

    private var chatChannels: Output<List<String>>? = null

    private var displayName: Output<String>? = null

    private var engagements: Output<List<String>>? = null

    private var incidentTemplate: Output<ResponsePlanIncidentTemplateArgs>? = null

    private var integration: Output<ResponsePlanIntegrationArgs>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The actions that the response plan starts at the beginning of an incident.
     */
    @JvmName("wohpkneutetvhenu")
    public suspend fun action(`value`: Output<ResponsePlanActionArgs>) {
        this.action = value
    }

    /**
     * @param value The Chatbot chat channel used for collaboration during an incident.
     */
    @JvmName("gwbqmqkmjkehfwxj")
    public suspend fun chatChannels(`value`: Output<List<String>>) {
        this.chatChannels = value
    }

    @JvmName("gfbmojuyytfvyiug")
    public suspend fun chatChannels(vararg values: Output<String>) {
        this.chatChannels = Output.all(values.asList())
    }

    /**
     * @param values The Chatbot chat channel used for collaboration during an incident.
     */
    @JvmName("wdfhckybnyskfyxg")
    public suspend fun chatChannels(values: List<Output<String>>) {
        this.chatChannels = Output.all(values)
    }

    /**
     * @param value The long format of the response plan name. This field can contain spaces.
     */
    @JvmName("juaunkrpcedpmluh")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an incident.
     */
    @JvmName("lodbtbnieyenttca")
    public suspend fun engagements(`value`: Output<List<String>>) {
        this.engagements = value
    }

    @JvmName("nverpafddprawvmi")
    public suspend fun engagements(vararg values: Output<String>) {
        this.engagements = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an incident.
     */
    @JvmName("jpjwwaoooycjwdve")
    public suspend fun engagements(values: List<Output<String>>) {
        this.engagements = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("oiqrasipbraqqemk")
    public suspend fun incidentTemplate(`value`: Output<ResponsePlanIncidentTemplateArgs>) {
        this.incidentTemplate = value
    }

    /**
     * @param value Information about third-party services integrated into the response plan. The following values are supported:
     */
    @JvmName("lowbbppxpchwdxpc")
    public suspend fun integration(`value`: Output<ResponsePlanIntegrationArgs>) {
        this.integration = value
    }

    /**
     * @param value The name of the response plan.
     */
    @JvmName("xcfpvqgvnhovagnp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The tags applied to the response plan.
     */
    @JvmName("slwxicofudfdvkau")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The actions that the response plan starts at the beginning of an incident.
     */
    @JvmName("gohhgsosjpykoche")
    public suspend fun action(`value`: ResponsePlanActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument The actions that the response plan starts at the beginning of an incident.
     */
    @JvmName("nheijbxrvuixqqhp")
    public suspend fun action(argument: suspend ResponsePlanActionArgsBuilder.() -> Unit) {
        val toBeMapped = ResponsePlanActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value The Chatbot chat channel used for collaboration during an incident.
     */
    @JvmName("wbnftvqbptukxtrr")
    public suspend fun chatChannels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.chatChannels = mapped
    }

    /**
     * @param values The Chatbot chat channel used for collaboration during an incident.
     */
    @JvmName("erbksxemkrjteblo")
    public suspend fun chatChannels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.chatChannels = mapped
    }

    /**
     * @param value The long format of the response plan name. This field can contain spaces.
     */
    @JvmName("fkrwyqjtkpyrmaki")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an incident.
     */
    @JvmName("ndhcgdjvgfdmcpcm")
    public suspend fun engagements(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engagements = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an incident.
     */
    @JvmName("rbvtbqotqfjitims")
    public suspend fun engagements(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.engagements = mapped
    }

    /**
     * @param value
     */
    @JvmName("dgyvqkxyogrgudkr")
    public suspend fun incidentTemplate(`value`: ResponsePlanIncidentTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incidentTemplate = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lwjervxdubjocaas")
    public suspend
    fun incidentTemplate(argument: suspend ResponsePlanIncidentTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = ResponsePlanIncidentTemplateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.incidentTemplate = mapped
    }

    /**
     * @param value Information about third-party services integrated into the response plan. The following values are supported:
     */
    @JvmName("lcrckhlwrfkjcdla")
    public suspend fun integration(`value`: ResponsePlanIntegrationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integration = mapped
    }

    /**
     * @param argument Information about third-party services integrated into the response plan. The following values are supported:
     */
    @JvmName("saqpkjxhieomvxhe")
    public suspend fun integration(argument: suspend ResponsePlanIntegrationArgsBuilder.() -> Unit) {
        val toBeMapped = ResponsePlanIntegrationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.integration = mapped
    }

    /**
     * @param value The name of the response plan.
     */
    @JvmName("ivegtabvjtmrgrvw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The tags applied to the response plan.
     */
    @JvmName("unepxoofdsjqmkln")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags applied to the response plan.
     */
    @JvmName("ngngsxartskfrsrd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ResponsePlanArgs = ResponsePlanArgs(
        action = action,
        chatChannels = chatChannels,
        displayName = displayName,
        engagements = engagements,
        incidentTemplate = incidentTemplate,
        integration = integration,
        name = name,
        tags = tags,
    )
}
