@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin

import com.pulumi.aws.ssmincidents.SsmincidentsFunctions.getReplicationSetPlain
import com.pulumi.aws.ssmincidents.SsmincidentsFunctions.getResponsePlanPlain
import com.pulumi.aws.ssmincidents.kotlin.inputs.GetReplicationSetPlainArgs
import com.pulumi.aws.ssmincidents.kotlin.inputs.GetReplicationSetPlainArgsBuilder
import com.pulumi.aws.ssmincidents.kotlin.inputs.GetResponsePlanPlainArgs
import com.pulumi.aws.ssmincidents.kotlin.inputs.GetResponsePlanPlainArgsBuilder
import com.pulumi.aws.ssmincidents.kotlin.outputs.GetReplicationSetResult
import com.pulumi.aws.ssmincidents.kotlin.outputs.GetResponsePlanResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.ssmincidents.kotlin.outputs.GetReplicationSetResult.Companion.toKotlin as getReplicationSetResultToKotlin
import com.pulumi.aws.ssmincidents.kotlin.outputs.GetResponsePlanResult.Companion.toKotlin as getResponsePlanResultToKotlin

public object SsmincidentsFunctions {
    /**
     * > **NOTE:** The AWS Region specified by a provider must always be one of the Regions specified for the replication set.
     * Use this data source to manage a replication set in AWS Systems Manager Incident Manager.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssmincidents.SsmincidentsFunctions;
     * import com.pulumi.aws.ssmincidents.inputs.GetReplicationSetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsmincidentsFunctions.getReplicationSet();
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getReplicationSet.
     * @return A collection of values returned by getReplicationSet.
     */
    public suspend fun getReplicationSet(argument: GetReplicationSetPlainArgs):
        GetReplicationSetResult =
        getReplicationSetResultToKotlin(getReplicationSetPlain(argument.toJava()).await())

    /**
     * @see [getReplicationSet].
     * @param tags All tags applied to the replication set.
     * @return A collection of values returned by getReplicationSet.
     */
    public suspend fun getReplicationSet(tags: Map<String, String>? = null): GetReplicationSetResult {
        val argument = GetReplicationSetPlainArgs(
            tags = tags,
        )
        return getReplicationSetResultToKotlin(getReplicationSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationSet].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssmincidents&#46;kotlin&#46;inputs&#46;GetReplicationSetPlainArgs].
     * @return A collection of values returned by getReplicationSet.
     */
    public suspend
    fun getReplicationSet(argument: suspend GetReplicationSetPlainArgsBuilder.() -> Unit):
        GetReplicationSetResult {
        val builder = GetReplicationSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationSetResultToKotlin(getReplicationSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to manage a response plan in AWS Systems Manager Incident Manager.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssmincidents.ResponsePlan;
     * import com.pulumi.aws.ssmincidents.ResponsePlanArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var example = new ResponsePlan("example", ResponsePlanArgs.builder()
     *             .arn("exampleARN")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getResponsePlan.
     * @return A collection of values returned by getResponsePlan.
     */
    public suspend fun getResponsePlan(argument: GetResponsePlanPlainArgs): GetResponsePlanResult =
        getResponsePlanResultToKotlin(getResponsePlanPlain(argument.toJava()).await())

    /**
     * @see [getResponsePlan].
     * @param arn The Amazon Resource Name (ARN) of the response plan.
     * @param tags The tags applied to the response plan.
     * @return A collection of values returned by getResponsePlan.
     */
    public suspend fun getResponsePlan(arn: String, tags: Map<String, String>? = null):
        GetResponsePlanResult {
        val argument = GetResponsePlanPlainArgs(
            arn = arn,
            tags = tags,
        )
        return getResponsePlanResultToKotlin(getResponsePlanPlain(argument.toJava()).await())
    }

    /**
     * @see [getResponsePlan].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssmincidents&#46;kotlin&#46;inputs&#46;GetResponsePlanPlainArgs].
     * @return A collection of values returned by getResponsePlan.
     */
    public suspend fun getResponsePlan(argument: suspend GetResponsePlanPlainArgsBuilder.() -> Unit):
        GetResponsePlanResult {
        val builder = GetResponsePlanPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResponsePlanResultToKotlin(getResponsePlanPlain(builtArgument.toJava()).await())
    }
}
