@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.inputs

import com.pulumi.aws.ssmincidents.inputs.GetResponsePlanPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResponsePlan.
 * @property arn The Amazon Resource Name (ARN) of the response plan.
 * @property tags The tags applied to the response plan.
 */
public data class GetResponsePlanPlainArgs(
    public val arn: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssmincidents.inputs.GetResponsePlanPlainArgs> {
    override fun toJava(): com.pulumi.aws.ssmincidents.inputs.GetResponsePlanPlainArgs =
        com.pulumi.aws.ssmincidents.inputs.GetResponsePlanPlainArgs.builder()
            .arn(arn.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetResponsePlanPlainArgs].
 */
@PulumiTagMarker
public class GetResponsePlanPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the response plan.
     */
    @JvmName("gispofcsvkatjtek")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value The tags applied to the response plan.
     */
    @JvmName("qelfuhioxngspmkj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values The tags applied to the response plan.
     */
    @JvmName("ischvsshgtwtvvqr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetResponsePlanPlainArgs = GetResponsePlanPlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        tags = tags,
    )
}
