@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.inputs

import com.pulumi.aws.ssmincidents.inputs.ReplicationSetRegionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyArn The Amazon Resource name (ARN) of the customer managed key. If omitted, AWS manages the AWS KMS keys for you, using an AWS owned key, as indicated by a default value of `DefaultKey`.
 * The following arguments are optional:
 * @property name The name of the Region, such as `ap-southeast-2`.
 * @property status The current status of the Region.
 * * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
 * @property statusMessage More information about the status of a Region.
 */
public data class ReplicationSetRegionArgs(
    public val kmsKeyArn: Output<String>? = null,
    public val name: Output<String>,
    public val status: Output<String>? = null,
    public val statusMessage: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssmincidents.inputs.ReplicationSetRegionArgs> {
    override fun toJava(): com.pulumi.aws.ssmincidents.inputs.ReplicationSetRegionArgs =
        com.pulumi.aws.ssmincidents.inputs.ReplicationSetRegionArgs.builder()
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .statusMessage(statusMessage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationSetRegionArgs].
 */
@PulumiTagMarker
public class ReplicationSetRegionArgsBuilder internal constructor() {
    private var kmsKeyArn: Output<String>? = null

    private var name: Output<String>? = null

    private var status: Output<String>? = null

    private var statusMessage: Output<String>? = null

    /**
     * @param value The Amazon Resource name (ARN) of the customer managed key. If omitted, AWS manages the AWS KMS keys for you, using an AWS owned key, as indicated by a default value of `DefaultKey`.
     * The following arguments are optional:
     */
    @JvmName("yotyfsfwbyvrmfwk")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value The name of the Region, such as `ap-southeast-2`.
     */
    @JvmName("gvntdggqvyyavmwm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The current status of the Region.
     * * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
     */
    @JvmName("xyxtcjrxvlgepgry")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value More information about the status of a Region.
     */
    @JvmName("mpgyumffdbwtskmy")
    public suspend fun statusMessage(`value`: Output<String>) {
        this.statusMessage = value
    }

    /**
     * @param value The Amazon Resource name (ARN) of the customer managed key. If omitted, AWS manages the AWS KMS keys for you, using an AWS owned key, as indicated by a default value of `DefaultKey`.
     * The following arguments are optional:
     */
    @JvmName("tqtlqeslktwvrexe")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value The name of the Region, such as `ap-southeast-2`.
     */
    @JvmName("mhflssrykjjtadyn")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The current status of the Region.
     * * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
     */
    @JvmName("ylsnxswfytspbmom")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value More information about the status of a Region.
     */
    @JvmName("mtebyyaqgjriisvw")
    public suspend fun statusMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statusMessage = mapped
    }

    internal fun build(): ReplicationSetRegionArgs = ReplicationSetRegionArgs(
        kmsKeyArn = kmsKeyArn,
        name = name ?: throw PulumiNullFieldException("name"),
        status = status,
        statusMessage = statusMessage,
    )
}
