@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.inputs

import com.pulumi.aws.ssmincidents.inputs.ResponsePlanActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ssmAutomations The Systems Manager automation document to start as the runbook at the beginning of the incident. The following values are supported:
 */
public data class ResponsePlanActionArgs(
    public val ssmAutomations: Output<List<ResponsePlanActionSsmAutomationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssmincidents.inputs.ResponsePlanActionArgs> {
    override fun toJava(): com.pulumi.aws.ssmincidents.inputs.ResponsePlanActionArgs =
        com.pulumi.aws.ssmincidents.inputs.ResponsePlanActionArgs.builder()
            .ssmAutomations(
                ssmAutomations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResponsePlanActionArgs].
 */
@PulumiTagMarker
public class ResponsePlanActionArgsBuilder internal constructor() {
    private var ssmAutomations: Output<List<ResponsePlanActionSsmAutomationArgs>>? = null

    /**
     * @param value The Systems Manager automation document to start as the runbook at the beginning of the incident. The following values are supported:
     */
    @JvmName("rebgucvdujfhvhwb")
    public suspend fun ssmAutomations(`value`: Output<List<ResponsePlanActionSsmAutomationArgs>>) {
        this.ssmAutomations = value
    }

    @JvmName("clkbkyuuoisdwkbf")
    public suspend fun ssmAutomations(vararg values: Output<ResponsePlanActionSsmAutomationArgs>) {
        this.ssmAutomations = Output.all(values.asList())
    }

    /**
     * @param values The Systems Manager automation document to start as the runbook at the beginning of the incident. The following values are supported:
     */
    @JvmName("mtuekcshlvdulikg")
    public suspend fun ssmAutomations(values: List<Output<ResponsePlanActionSsmAutomationArgs>>) {
        this.ssmAutomations = Output.all(values)
    }

    /**
     * @param value The Systems Manager automation document to start as the runbook at the beginning of the incident. The following values are supported:
     */
    @JvmName("muvclticiviynkxk")
    public suspend fun ssmAutomations(`value`: List<ResponsePlanActionSsmAutomationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssmAutomations = mapped
    }

    /**
     * @param argument The Systems Manager automation document to start as the runbook at the beginning of the incident. The following values are supported:
     */
    @JvmName("torioqjrdjgjkyjd")
    public suspend
    fun ssmAutomations(argument: List<suspend ResponsePlanActionSsmAutomationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResponsePlanActionSsmAutomationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ssmAutomations = mapped
    }

    /**
     * @param argument The Systems Manager automation document to start as the runbook at the beginning of the incident. The following values are supported:
     */
    @JvmName("rbjljjkqikbwlgqw")
    public suspend fun ssmAutomations(
        vararg
        argument: suspend ResponsePlanActionSsmAutomationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResponsePlanActionSsmAutomationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ssmAutomations = mapped
    }

    /**
     * @param argument The Systems Manager automation document to start as the runbook at the beginning of the incident. The following values are supported:
     */
    @JvmName("arxkufcrnfvfpbcs")
    public suspend
    fun ssmAutomations(argument: suspend ResponsePlanActionSsmAutomationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ResponsePlanActionSsmAutomationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ssmAutomations = mapped
    }

    /**
     * @param values The Systems Manager automation document to start as the runbook at the beginning of the incident. The following values are supported:
     */
    @JvmName("fgtsbhlboovbdmrd")
    public suspend fun ssmAutomations(vararg values: ResponsePlanActionSsmAutomationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ssmAutomations = mapped
    }

    internal fun build(): ResponsePlanActionArgs = ResponsePlanActionArgs(
        ssmAutomations = ssmAutomations,
    )
}
