@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.inputs

import com.pulumi.aws.ssmincidents.inputs.ResponsePlanActionSsmAutomationParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the response plan.
 * @property values The values for the associated parameter name.
 */
public data class ResponsePlanActionSsmAutomationParameterArgs(
    public val name: Output<String>,
    public val values: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.ssmincidents.inputs.ResponsePlanActionSsmAutomationParameterArgs> {
    override fun toJava():
        com.pulumi.aws.ssmincidents.inputs.ResponsePlanActionSsmAutomationParameterArgs =
        com.pulumi.aws.ssmincidents.inputs.ResponsePlanActionSsmAutomationParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ResponsePlanActionSsmAutomationParameterArgs].
 */
@PulumiTagMarker
public class ResponsePlanActionSsmAutomationParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value The name of the response plan.
     */
    @JvmName("qcdlveqadftuohlg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The values for the associated parameter name.
     */
    @JvmName("auksyxdinclhfuds")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("tacwftfambkxkuqv")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values The values for the associated parameter name.
     */
    @JvmName("giysgdmmblvfwmfs")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value The name of the response plan.
     */
    @JvmName("jtvbcxhplccrjjwa")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The values for the associated parameter name.
     */
    @JvmName("kpbxocswygylemvg")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values The values for the associated parameter name.
     */
    @JvmName("xpbdvmbxeiduqwtg")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): ResponsePlanActionSsmAutomationParameterArgs =
        ResponsePlanActionSsmAutomationParameterArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            values = values ?: throw PulumiNullFieldException("values"),
        )
}
