@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.inputs

import com.pulumi.aws.ssmincidents.inputs.ResponsePlanIncidentTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property dedupeString A string used to stop Incident Manager from creating multiple incident records for the same incident.
 * @property impact The impact value of a generated incident. The following values are supported:
 * @property incidentTags The tags assigned to an incident template. When an incident starts, Incident Manager assigns the tags specified in the template to the incident.
 * @property notificationTargets The Amazon Simple Notification Service (Amazon SNS) targets that this incident notifies when it is updated. The `notification_target` configuration block supports the following argument:
 * @property summary The summary of an incident.
 * @property title The title of a generated incident.
 */
public data class ResponsePlanIncidentTemplateArgs(
    public val dedupeString: Output<String>? = null,
    public val impact: Output<Int>,
    public val incidentTags: Output<Map<String, String>>? = null,
    public val notificationTargets: Output<List<ResponsePlanIncidentTemplateNotificationTargetArgs>>? =
        null,
    public val summary: Output<String>? = null,
    public val title: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ssmincidents.inputs.ResponsePlanIncidentTemplateArgs> {
    override fun toJava(): com.pulumi.aws.ssmincidents.inputs.ResponsePlanIncidentTemplateArgs =
        com.pulumi.aws.ssmincidents.inputs.ResponsePlanIncidentTemplateArgs.builder()
            .dedupeString(dedupeString?.applyValue({ args0 -> args0 }))
            .impact(impact.applyValue({ args0 -> args0 }))
            .incidentTags(
                incidentTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .notificationTargets(
                notificationTargets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .summary(summary?.applyValue({ args0 -> args0 }))
            .title(title.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResponsePlanIncidentTemplateArgs].
 */
@PulumiTagMarker
public class ResponsePlanIncidentTemplateArgsBuilder internal constructor() {
    private var dedupeString: Output<String>? = null

    private var impact: Output<Int>? = null

    private var incidentTags: Output<Map<String, String>>? = null

    private var notificationTargets: Output<List<ResponsePlanIncidentTemplateNotificationTargetArgs>>? =
        null

    private var summary: Output<String>? = null

    private var title: Output<String>? = null

    /**
     * @param value A string used to stop Incident Manager from creating multiple incident records for the same incident.
     */
    @JvmName("ycgwnauntnxdurmb")
    public suspend fun dedupeString(`value`: Output<String>) {
        this.dedupeString = value
    }

    /**
     * @param value The impact value of a generated incident. The following values are supported:
     */
    @JvmName("yqsbyhplcrkgfbqs")
    public suspend fun impact(`value`: Output<Int>) {
        this.impact = value
    }

    /**
     * @param value The tags assigned to an incident template. When an incident starts, Incident Manager assigns the tags specified in the template to the incident.
     */
    @JvmName("vdbhwhcbbybgltsn")
    public suspend fun incidentTags(`value`: Output<Map<String, String>>) {
        this.incidentTags = value
    }

    /**
     * @param value The Amazon Simple Notification Service (Amazon SNS) targets that this incident notifies when it is updated. The `notification_target` configuration block supports the following argument:
     */
    @JvmName("nbwancdhoqrebwck")
    public suspend
    fun notificationTargets(`value`: Output<List<ResponsePlanIncidentTemplateNotificationTargetArgs>>) {
        this.notificationTargets = value
    }

    @JvmName("nfoytmhjdtbohpvx")
    public suspend fun notificationTargets(
        vararg
        values: Output<ResponsePlanIncidentTemplateNotificationTargetArgs>,
    ) {
        this.notificationTargets = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Simple Notification Service (Amazon SNS) targets that this incident notifies when it is updated. The `notification_target` configuration block supports the following argument:
     */
    @JvmName("aqfamtgmhtfbmbnm")
    public suspend
    fun notificationTargets(values: List<Output<ResponsePlanIncidentTemplateNotificationTargetArgs>>) {
        this.notificationTargets = Output.all(values)
    }

    /**
     * @param value The summary of an incident.
     */
    @JvmName("jtmffmkrpptrxrbk")
    public suspend fun summary(`value`: Output<String>) {
        this.summary = value
    }

    /**
     * @param value The title of a generated incident.
     */
    @JvmName("woidupfokiygsgqd")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value A string used to stop Incident Manager from creating multiple incident records for the same incident.
     */
    @JvmName("ravmkogeackiuafc")
    public suspend fun dedupeString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedupeString = mapped
    }

    /**
     * @param value The impact value of a generated incident. The following values are supported:
     */
    @JvmName("jkjofdtogtnaddgk")
    public suspend fun impact(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.impact = mapped
    }

    /**
     * @param value The tags assigned to an incident template. When an incident starts, Incident Manager assigns the tags specified in the template to the incident.
     */
    @JvmName("uojcxppommfvrsnj")
    public suspend fun incidentTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incidentTags = mapped
    }

    /**
     * @param values The tags assigned to an incident template. When an incident starts, Incident Manager assigns the tags specified in the template to the incident.
     */
    @JvmName("pybausjwtsxmbstq")
    public fun incidentTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.incidentTags = mapped
    }

    /**
     * @param value The Amazon Simple Notification Service (Amazon SNS) targets that this incident notifies when it is updated. The `notification_target` configuration block supports the following argument:
     */
    @JvmName("sjhtgppdpqnldqvk")
    public suspend
    fun notificationTargets(`value`: List<ResponsePlanIncidentTemplateNotificationTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationTargets = mapped
    }

    /**
     * @param argument The Amazon Simple Notification Service (Amazon SNS) targets that this incident notifies when it is updated. The `notification_target` configuration block supports the following argument:
     */
    @JvmName("frjahkkiemhnytcd")
    public suspend
    fun notificationTargets(argument: List<suspend ResponsePlanIncidentTemplateNotificationTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResponsePlanIncidentTemplateNotificationTargetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.notificationTargets = mapped
    }

    /**
     * @param argument The Amazon Simple Notification Service (Amazon SNS) targets that this incident notifies when it is updated. The `notification_target` configuration block supports the following argument:
     */
    @JvmName("wjkekmjhxpbdaenw")
    public suspend fun notificationTargets(
        vararg
        argument: suspend ResponsePlanIncidentTemplateNotificationTargetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResponsePlanIncidentTemplateNotificationTargetArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.notificationTargets = mapped
    }

    /**
     * @param argument The Amazon Simple Notification Service (Amazon SNS) targets that this incident notifies when it is updated. The `notification_target` configuration block supports the following argument:
     */
    @JvmName("ohvjkhsiuuwojtid")
    public suspend
    fun notificationTargets(argument: suspend ResponsePlanIncidentTemplateNotificationTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ResponsePlanIncidentTemplateNotificationTargetArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.notificationTargets = mapped
    }

    /**
     * @param values The Amazon Simple Notification Service (Amazon SNS) targets that this incident notifies when it is updated. The `notification_target` configuration block supports the following argument:
     */
    @JvmName("vkdtbkcoijwhpsnd")
    public suspend fun notificationTargets(
        vararg
        values: ResponsePlanIncidentTemplateNotificationTargetArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationTargets = mapped
    }

    /**
     * @param value The summary of an incident.
     */
    @JvmName("fnwwkacorgphbaev")
    public suspend fun summary(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.summary = mapped
    }

    /**
     * @param value The title of a generated incident.
     */
    @JvmName("wtsowhvvqwndhwbh")
    public suspend fun title(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): ResponsePlanIncidentTemplateArgs = ResponsePlanIncidentTemplateArgs(
        dedupeString = dedupeString,
        impact = impact ?: throw PulumiNullFieldException("impact"),
        incidentTags = incidentTags,
        notificationTargets = notificationTargets,
        summary = summary,
        title = title ?: throw PulumiNullFieldException("title"),
    )
}
