@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.inputs

import com.pulumi.aws.ssmincidents.inputs.ResponsePlanIncidentTemplateNotificationTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property snsTopicArn The ARN of the Amazon SNS topic.
 * The following arguments are optional:
 */
public data class ResponsePlanIncidentTemplateNotificationTargetArgs(
    public val snsTopicArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.ssmincidents.inputs.ResponsePlanIncidentTemplateNotificationTargetArgs> {
    override fun toJava():
        com.pulumi.aws.ssmincidents.inputs.ResponsePlanIncidentTemplateNotificationTargetArgs =
        com.pulumi.aws.ssmincidents.inputs.ResponsePlanIncidentTemplateNotificationTargetArgs.builder()
            .snsTopicArn(snsTopicArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResponsePlanIncidentTemplateNotificationTargetArgs].
 */
@PulumiTagMarker
public class ResponsePlanIncidentTemplateNotificationTargetArgsBuilder internal constructor() {
    private var snsTopicArn: Output<String>? = null

    /**
     * @param value The ARN of the Amazon SNS topic.
     * The following arguments are optional:
     */
    @JvmName("pwnjxlshcodurkpg")
    public suspend fun snsTopicArn(`value`: Output<String>) {
        this.snsTopicArn = value
    }

    /**
     * @param value The ARN of the Amazon SNS topic.
     * The following arguments are optional:
     */
    @JvmName("fuylsntviwarjufb")
    public suspend fun snsTopicArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snsTopicArn = mapped
    }

    internal fun build(): ResponsePlanIncidentTemplateNotificationTargetArgs =
        ResponsePlanIncidentTemplateNotificationTargetArgs(
            snsTopicArn = snsTopicArn ?: throw PulumiNullFieldException("snsTopicArn"),
        )
}
