@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.inputs

import com.pulumi.aws.ssmincidents.inputs.ResponsePlanIntegrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property pagerduties Details about the PagerDuty configuration for a response plan. The following values are supported:
 */
public data class ResponsePlanIntegrationArgs(
    public val pagerduties: Output<List<ResponsePlanIntegrationPagerdutyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssmincidents.inputs.ResponsePlanIntegrationArgs> {
    override fun toJava(): com.pulumi.aws.ssmincidents.inputs.ResponsePlanIntegrationArgs =
        com.pulumi.aws.ssmincidents.inputs.ResponsePlanIntegrationArgs.builder()
            .pagerduties(
                pagerduties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResponsePlanIntegrationArgs].
 */
@PulumiTagMarker
public class ResponsePlanIntegrationArgsBuilder internal constructor() {
    private var pagerduties: Output<List<ResponsePlanIntegrationPagerdutyArgs>>? = null

    /**
     * @param value Details about the PagerDuty configuration for a response plan. The following values are supported:
     */
    @JvmName("wtwbwittovrpxgtk")
    public suspend fun pagerduties(`value`: Output<List<ResponsePlanIntegrationPagerdutyArgs>>) {
        this.pagerduties = value
    }

    @JvmName("lxdqebqogjvfspwp")
    public suspend fun pagerduties(vararg values: Output<ResponsePlanIntegrationPagerdutyArgs>) {
        this.pagerduties = Output.all(values.asList())
    }

    /**
     * @param values Details about the PagerDuty configuration for a response plan. The following values are supported:
     */
    @JvmName("rtylwwrqfxedlvwk")
    public suspend fun pagerduties(values: List<Output<ResponsePlanIntegrationPagerdutyArgs>>) {
        this.pagerduties = Output.all(values)
    }

    /**
     * @param value Details about the PagerDuty configuration for a response plan. The following values are supported:
     */
    @JvmName("cnhmbkdewcjmkybi")
    public suspend fun pagerduties(`value`: List<ResponsePlanIntegrationPagerdutyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pagerduties = mapped
    }

    /**
     * @param argument Details about the PagerDuty configuration for a response plan. The following values are supported:
     */
    @JvmName("iaumkberqwpqhygc")
    public suspend
    fun pagerduties(argument: List<suspend ResponsePlanIntegrationPagerdutyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResponsePlanIntegrationPagerdutyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.pagerduties = mapped
    }

    /**
     * @param argument Details about the PagerDuty configuration for a response plan. The following values are supported:
     */
    @JvmName("saimaylkbewsepln")
    public suspend fun pagerduties(
        vararg
        argument: suspend ResponsePlanIntegrationPagerdutyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResponsePlanIntegrationPagerdutyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.pagerduties = mapped
    }

    /**
     * @param argument Details about the PagerDuty configuration for a response plan. The following values are supported:
     */
    @JvmName("btyotxohkuawlsub")
    public suspend
    fun pagerduties(argument: suspend ResponsePlanIntegrationPagerdutyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ResponsePlanIntegrationPagerdutyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.pagerduties = mapped
    }

    /**
     * @param values Details about the PagerDuty configuration for a response plan. The following values are supported:
     */
    @JvmName("peyhavqgpkodbiji")
    public suspend fun pagerduties(vararg values: ResponsePlanIntegrationPagerdutyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pagerduties = mapped
    }

    internal fun build(): ResponsePlanIntegrationArgs = ResponsePlanIntegrationArgs(
        pagerduties = pagerduties,
    )
}
