@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyArn The ARN of the AWS Key Management Service (AWS KMS) encryption key.
 * @property name The name of the Region.
 * @property status The current status of the Region.
 * * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
 * @property statusMessage More information about the status of a Region.
 */
public data class GetReplicationSetRegion(
    public val kmsKeyArn: String,
    public val name: String,
    public val status: String,
    public val statusMessage: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssmincidents.outputs.GetReplicationSetRegion):
            GetReplicationSetRegion = GetReplicationSetRegion(
            kmsKeyArn = javaType.kmsKeyArn(),
            name = javaType.name(),
            status = javaType.status(),
            statusMessage = javaType.statusMessage(),
        )
    }
}
