@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property dedupeString A string used to stop Incident Manager from creating multiple incident records for the same incident.
 * @property impact The impact value of a generated incident. The following values are supported:
 * @property incidentTags The tags assigned to an incident template. When an incident starts, Incident Manager assigns the tags specified in the template to the incident.
 * @property notificationTargets The Amazon Simple Notification Service (Amazon SNS) targets that this incident notifies when it is updated. The `notification_target` configuration block supports the following argument:
 * @property summary The summary of an incident.
 * @property title The title of a generated incident.
 */
public data class GetResponsePlanIncidentTemplate(
    public val dedupeString: String,
    public val impact: Int,
    public val incidentTags: Map<String, String>,
    public val notificationTargets: List<GetResponsePlanIncidentTemplateNotificationTarget>,
    public val summary: String,
    public val title: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ssmincidents.outputs.GetResponsePlanIncidentTemplate):
            GetResponsePlanIncidentTemplate = GetResponsePlanIncidentTemplate(
            dedupeString = javaType.dedupeString(),
            impact = javaType.impact(),
            incidentTags = javaType.incidentTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            notificationTargets = javaType.notificationTargets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssmincidents.kotlin.outputs.GetResponsePlanIncidentTemplateNotificationTarget.Companion.toKotlin(args0)
                })
            }),
            summary = javaType.summary(),
            title = javaType.title(),
        )
    }
}
