@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name The name of the PagerDuty configuration.
 * @property secretId The ID of the AWS Secrets Manager secret that stores your PagerDuty key &mdash; either a General Access REST API Key or User Token REST API Key &mdash; and other user credentials.
 * @property serviceId The ID of the PagerDuty service that the response plan associates with an incident when it launches.
 */
public data class GetResponsePlanIntegrationPagerduty(
    public val name: String,
    public val secretId: String,
    public val serviceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.ssmincidents.outputs.GetResponsePlanIntegrationPagerduty):
            GetResponsePlanIntegrationPagerduty = GetResponsePlanIntegrationPagerduty(
            name = javaType.name(),
            secretId = javaType.secretId(),
            serviceId = javaType.serviceId(),
        )
    }
}
