@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getResponsePlan.
 * @property actions (Optional) The actions that the response plan starts at the beginning of an incident.
 * @property arn
 * @property chatChannels The Chatbot chat channel used for collaboration during an incident.
 * @property displayName The long format of the response plan name. This field can contain spaces.
 * @property engagements The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an incident.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property incidentTemplates
 * @property integrations Information about third-party services integrated into the response plan. The following values are supported:
 * @property name The name of the PagerDuty configuration.
 * @property tags The tags applied to the response plan.
 */
public data class GetResponsePlanResult(
    public val actions: List<GetResponsePlanAction>,
    public val arn: String,
    public val chatChannels: List<String>,
    public val displayName: String,
    public val engagements: List<String>,
    public val id: String,
    public val incidentTemplates: List<GetResponsePlanIncidentTemplate>,
    public val integrations: List<GetResponsePlanIntegration>,
    public val name: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssmincidents.outputs.GetResponsePlanResult):
            GetResponsePlanResult = GetResponsePlanResult(
            actions = javaType.actions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssmincidents.kotlin.outputs.GetResponsePlanAction.Companion.toKotlin(args0)
                })
            }),
            arn = javaType.arn(),
            chatChannels = javaType.chatChannels().map({ args0 -> args0 }),
            displayName = javaType.displayName(),
            engagements = javaType.engagements().map({ args0 -> args0 }),
            id = javaType.id(),
            incidentTemplates = javaType.incidentTemplates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssmincidents.kotlin.outputs.GetResponsePlanIncidentTemplate.Companion.toKotlin(args0)
                })
            }),
            integrations = javaType.integrations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssmincidents.kotlin.outputs.GetResponsePlanIntegration.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
