@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssmincidents.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyArn The Amazon Resource name (ARN) of the customer managed key. If omitted, AWS manages the AWS KMS keys for you, using an AWS owned key, as indicated by a default value of `DefaultKey`.
 * The following arguments are optional:
 * @property name The name of the Region, such as `ap-southeast-2`.
 * @property status The current status of the Region.
 * * Valid Values: `ACTIVE` | `CREATING` | `UPDATING` | `DELETING` | `FAILED`
 * @property statusMessage More information about the status of a Region.
 */
public data class ReplicationSetRegion(
    public val kmsKeyArn: String? = null,
    public val name: String,
    public val status: String? = null,
    public val statusMessage: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssmincidents.outputs.ReplicationSetRegion):
            ReplicationSetRegion = ReplicationSetRegion(
            kmsKeyArn = javaType.kmsKeyArn().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            statusMessage = javaType.statusMessage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
