@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccountAssignment].
 */
@PulumiTagMarker
public class AccountAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountAssignmentArgs = AccountAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountAssignmentArgsBuilder.() -> Unit) {
        val builder = AccountAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AccountAssignment {
        val builtJavaResource = com.pulumi.aws.ssoadmin.AccountAssignment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccountAssignment(builtJavaResource)
    }
}

/**
 * Provides a Single Sign-On (SSO) Account Assignment resource
 * ## Import
 * Using `pulumi import`, import SSO Account Assignments using the `principal_id`, `principal_type`, `target_id`, `target_type`, `permission_set_arn`, `instance_arn` separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ssoadmin/accountAssignment:AccountAssignment example f81d4fae-7dec-11d0-a765-00a0c91e6bf6,GROUP,1234567890,AWS_ACCOUNT,arn:aws:sso:::permissionSet/ssoins-0123456789abcdef/ps-0123456789abcdef,arn:aws:sso:::instance/ssoins-0123456789abcdef
 * ```
 *
 */
public class AccountAssignment internal constructor(
    override val javaResource: com.pulumi.aws.ssoadmin.AccountAssignment,
) : KotlinCustomResource(javaResource, AccountAssignmentMapper) {
    /**
     * The Amazon Resource Name (ARN) of the SSO Instance.
     */
    public val instanceArn: Output<String>
        get() = javaResource.instanceArn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the Permission Set that the admin wants to grant the principal access to.
     */
    public val permissionSetArn: Output<String>
        get() = javaResource.permissionSetArn().applyValue({ args0 -> args0 })

    /**
     * An identifier for an object in SSO, such as a user or group. PrincipalIds are GUIDs (For example, `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`).
     */
    public val principalId: Output<String>
        get() = javaResource.principalId().applyValue({ args0 -> args0 })

    /**
     * The entity type for which the assignment will be created. Valid values: `USER`, `GROUP`.
     */
    public val principalType: Output<String>
        get() = javaResource.principalType().applyValue({ args0 -> args0 })

    /**
     * An AWS account identifier, typically a 10-12 digit string.
     */
    public val targetId: Output<String>
        get() = javaResource.targetId().applyValue({ args0 -> args0 })

    /**
     * The entity type for which the assignment will be created. Valid values: `AWS_ACCOUNT`.
     */
    public val targetType: Output<String>?
        get() = javaResource.targetType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AccountAssignmentMapper : ResourceMapper<AccountAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssoadmin.AccountAssignment::class == javaResource::class

    override fun map(javaResource: Resource): AccountAssignment = AccountAssignment(
        javaResource as
            com.pulumi.aws.ssoadmin.AccountAssignment,
    )
}

/**
 * @see [AccountAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccountAssignment].
 */
public suspend fun accountAssignment(
    name: String,
    block: suspend AccountAssignmentResourceBuilder.() -> Unit,
): AccountAssignment {
    val builder = AccountAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccountAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accountAssignment(name: String): AccountAssignment {
    val builder = AccountAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
