@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.AccountAssignmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Single Sign-On (SSO) Account Assignment resource
 * ## Import
 * Using `pulumi import`, import SSO Account Assignments using the `principal_id`, `principal_type`, `target_id`, `target_type`, `permission_set_arn`, `instance_arn` separated by commas (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ssoadmin/accountAssignment:AccountAssignment example f81d4fae-7dec-11d0-a765-00a0c91e6bf6,GROUP,1234567890,AWS_ACCOUNT,arn:aws:sso:::permissionSet/ssoins-0123456789abcdef/ps-0123456789abcdef,arn:aws:sso:::instance/ssoins-0123456789abcdef
 * ```
 * @property instanceArn The Amazon Resource Name (ARN) of the SSO Instance.
 * @property permissionSetArn The Amazon Resource Name (ARN) of the Permission Set that the admin wants to grant the principal access to.
 * @property principalId An identifier for an object in SSO, such as a user or group. PrincipalIds are GUIDs (For example, `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`).
 * @property principalType The entity type for which the assignment will be created. Valid values: `USER`, `GROUP`.
 * @property targetId An AWS account identifier, typically a 10-12 digit string.
 * @property targetType The entity type for which the assignment will be created. Valid values: `AWS_ACCOUNT`.
 */
public data class AccountAssignmentArgs(
    public val instanceArn: Output<String>? = null,
    public val permissionSetArn: Output<String>? = null,
    public val principalId: Output<String>? = null,
    public val principalType: Output<String>? = null,
    public val targetId: Output<String>? = null,
    public val targetType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.AccountAssignmentArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.AccountAssignmentArgs =
        com.pulumi.aws.ssoadmin.AccountAssignmentArgs.builder()
            .instanceArn(instanceArn?.applyValue({ args0 -> args0 }))
            .permissionSetArn(permissionSetArn?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .principalType(principalType?.applyValue({ args0 -> args0 }))
            .targetId(targetId?.applyValue({ args0 -> args0 }))
            .targetType(targetType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccountAssignmentArgs].
 */
@PulumiTagMarker
public class AccountAssignmentArgsBuilder internal constructor() {
    private var instanceArn: Output<String>? = null

    private var permissionSetArn: Output<String>? = null

    private var principalId: Output<String>? = null

    private var principalType: Output<String>? = null

    private var targetId: Output<String>? = null

    private var targetType: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance.
     */
    @JvmName("ftnvaghlrffdcfdt")
    public suspend fun instanceArn(`value`: Output<String>) {
        this.instanceArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Permission Set that the admin wants to grant the principal access to.
     */
    @JvmName("xjkxgcwovwvcehpn")
    public suspend fun permissionSetArn(`value`: Output<String>) {
        this.permissionSetArn = value
    }

    /**
     * @param value An identifier for an object in SSO, such as a user or group. PrincipalIds are GUIDs (For example, `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`).
     */
    @JvmName("upyqxhmkgxucsbta")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The entity type for which the assignment will be created. Valid values: `USER`, `GROUP`.
     */
    @JvmName("wttxratddrdkrnnt")
    public suspend fun principalType(`value`: Output<String>) {
        this.principalType = value
    }

    /**
     * @param value An AWS account identifier, typically a 10-12 digit string.
     */
    @JvmName("xmnrjcyqvjgbccyn")
    public suspend fun targetId(`value`: Output<String>) {
        this.targetId = value
    }

    /**
     * @param value The entity type for which the assignment will be created. Valid values: `AWS_ACCOUNT`.
     */
    @JvmName("irutkdkfedfuavrg")
    public suspend fun targetType(`value`: Output<String>) {
        this.targetType = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance.
     */
    @JvmName("twajmosobrmknsew")
    public suspend fun instanceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceArn = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Permission Set that the admin wants to grant the principal access to.
     */
    @JvmName("weeyuwqtmqgwbica")
    public suspend fun permissionSetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionSetArn = mapped
    }

    /**
     * @param value An identifier for an object in SSO, such as a user or group. PrincipalIds are GUIDs (For example, `f81d4fae-7dec-11d0-a765-00a0c91e6bf6`).
     */
    @JvmName("aydkfhkbcvqukoxn")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value The entity type for which the assignment will be created. Valid values: `USER`, `GROUP`.
     */
    @JvmName("tjusrmurojsisgby")
    public suspend fun principalType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value An AWS account identifier, typically a 10-12 digit string.
     */
    @JvmName("havvelkeiulqixto")
    public suspend fun targetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetId = mapped
    }

    /**
     * @param value The entity type for which the assignment will be created. Valid values: `AWS_ACCOUNT`.
     */
    @JvmName("ojjiqcmutonbclfu")
    public suspend fun targetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetType = mapped
    }

    internal fun build(): AccountAssignmentArgs = AccountAssignmentArgs(
        instanceArn = instanceArn,
        permissionSetArn = permissionSetArn,
        principalId = principalId,
        principalType = principalType,
        targetId = targetId,
        targetType = targetType,
    )
}
