@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.kotlin.outputs.CustomerManagedPolicyAttachmentCustomerManagedPolicyReference
import com.pulumi.aws.ssoadmin.kotlin.outputs.CustomerManagedPolicyAttachmentCustomerManagedPolicyReference.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CustomerManagedPolicyAttachment].
 */
@PulumiTagMarker
public class CustomerManagedPolicyAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomerManagedPolicyAttachmentArgs = CustomerManagedPolicyAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomerManagedPolicyAttachmentArgsBuilder.() -> Unit) {
        val builder = CustomerManagedPolicyAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CustomerManagedPolicyAttachment {
        val builtJavaResource =
            com.pulumi.aws.ssoadmin.CustomerManagedPolicyAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CustomerManagedPolicyAttachment(builtJavaResource)
    }
}

/**
 * Provides a customer managed policy attachment for a Single Sign-On (SSO) Permission Set resource
 * > **NOTE:** Creating this resource will automatically [Provision the Permission Set](https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ProvisionPermissionSet.html) to apply the corresponding updates to all assigned accounts.
 * ## Import
 * Using `pulumi import`, import SSO Managed Policy Attachments using the `name`, `path`, `permission_set_arn`, and `instance_arn` separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ssoadmin/customerManagedPolicyAttachment:CustomerManagedPolicyAttachment example TestPolicy,/,arn:aws:sso:::permissionSet/ssoins-2938j0x8920sbj72/ps-80383020jr9302rk,arn:aws:sso:::instance/ssoins-2938j0x8920sbj72
 * ```
 *
 */
public class CustomerManagedPolicyAttachment internal constructor(
    override val javaResource: com.pulumi.aws.ssoadmin.CustomerManagedPolicyAttachment,
) : KotlinCustomResource(javaResource, CustomerManagedPolicyAttachmentMapper) {
    /**
     * Specifies the name and path of a customer managed policy. See below.
     */
    public val customerManagedPolicyReference:
        Output<CustomerManagedPolicyAttachmentCustomerManagedPolicyReference>
        get() = javaResource.customerManagedPolicyReference().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    public val instanceArn: Output<String>
        get() = javaResource.instanceArn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the Permission Set.
     */
    public val permissionSetArn: Output<String>
        get() = javaResource.permissionSetArn().applyValue({ args0 -> args0 })
}

public object CustomerManagedPolicyAttachmentMapper :
    ResourceMapper<CustomerManagedPolicyAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssoadmin.CustomerManagedPolicyAttachment::class == javaResource::class

    override fun map(javaResource: Resource): CustomerManagedPolicyAttachment =
        CustomerManagedPolicyAttachment(
            javaResource as
                com.pulumi.aws.ssoadmin.CustomerManagedPolicyAttachment,
        )
}

/**
 * @see [CustomerManagedPolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomerManagedPolicyAttachment].
 */
public suspend fun customerManagedPolicyAttachment(
    name: String,
    block: suspend CustomerManagedPolicyAttachmentResourceBuilder.() -> Unit,
):
    CustomerManagedPolicyAttachment {
    val builder = CustomerManagedPolicyAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomerManagedPolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customerManagedPolicyAttachment(name: String): CustomerManagedPolicyAttachment {
    val builder = CustomerManagedPolicyAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
