@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.CustomerManagedPolicyAttachmentArgs.builder
import com.pulumi.aws.ssoadmin.kotlin.inputs.CustomerManagedPolicyAttachmentCustomerManagedPolicyReferenceArgs
import com.pulumi.aws.ssoadmin.kotlin.inputs.CustomerManagedPolicyAttachmentCustomerManagedPolicyReferenceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a customer managed policy attachment for a Single Sign-On (SSO) Permission Set resource
 * > **NOTE:** Creating this resource will automatically [Provision the Permission Set](https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ProvisionPermissionSet.html) to apply the corresponding updates to all assigned accounts.
 * ## Import
 * Using `pulumi import`, import SSO Managed Policy Attachments using the `name`, `path`, `permission_set_arn`, and `instance_arn` separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ssoadmin/customerManagedPolicyAttachment:CustomerManagedPolicyAttachment example TestPolicy,/,arn:aws:sso:::permissionSet/ssoins-2938j0x8920sbj72/ps-80383020jr9302rk,arn:aws:sso:::instance/ssoins-2938j0x8920sbj72
 * ```
 * @property customerManagedPolicyReference Specifies the name and path of a customer managed policy. See below.
 * @property instanceArn The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
 * @property permissionSetArn The Amazon Resource Name (ARN) of the Permission Set.
 */
public data class CustomerManagedPolicyAttachmentArgs(
    public val customerManagedPolicyReference:
    Output<CustomerManagedPolicyAttachmentCustomerManagedPolicyReferenceArgs>? = null,
    public val instanceArn: Output<String>? = null,
    public val permissionSetArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.CustomerManagedPolicyAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.CustomerManagedPolicyAttachmentArgs =
        com.pulumi.aws.ssoadmin.CustomerManagedPolicyAttachmentArgs.builder()
            .customerManagedPolicyReference(
                customerManagedPolicyReference?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .instanceArn(instanceArn?.applyValue({ args0 -> args0 }))
            .permissionSetArn(permissionSetArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomerManagedPolicyAttachmentArgs].
 */
@PulumiTagMarker
public class CustomerManagedPolicyAttachmentArgsBuilder internal constructor() {
    private var customerManagedPolicyReference:
        Output<CustomerManagedPolicyAttachmentCustomerManagedPolicyReferenceArgs>? = null

    private var instanceArn: Output<String>? = null

    private var permissionSetArn: Output<String>? = null

    /**
     * @param value Specifies the name and path of a customer managed policy. See below.
     */
    @JvmName("kttmsanamjfjdytc")
    public suspend
    fun customerManagedPolicyReference(`value`: Output<CustomerManagedPolicyAttachmentCustomerManagedPolicyReferenceArgs>) {
        this.customerManagedPolicyReference = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    @JvmName("sundjwperertakpp")
    public suspend fun instanceArn(`value`: Output<String>) {
        this.instanceArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Permission Set.
     */
    @JvmName("fxypxhcwlhhtmnmk")
    public suspend fun permissionSetArn(`value`: Output<String>) {
        this.permissionSetArn = value
    }

    /**
     * @param value Specifies the name and path of a customer managed policy. See below.
     */
    @JvmName("shwkqkvuhybvfmhk")
    public suspend
    fun customerManagedPolicyReference(`value`: CustomerManagedPolicyAttachmentCustomerManagedPolicyReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerManagedPolicyReference = mapped
    }

    /**
     * @param argument Specifies the name and path of a customer managed policy. See below.
     */
    @JvmName("htkirycyfinsmlxw")
    public suspend
    fun customerManagedPolicyReference(argument: suspend CustomerManagedPolicyAttachmentCustomerManagedPolicyReferenceArgsBuilder.() -> Unit) {
        val toBeMapped =
            CustomerManagedPolicyAttachmentCustomerManagedPolicyReferenceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customerManagedPolicyReference = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    @JvmName("rvvqgebhiycyhggp")
    public suspend fun instanceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceArn = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Permission Set.
     */
    @JvmName("hweeeedrjqxupjby")
    public suspend fun permissionSetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionSetArn = mapped
    }

    internal fun build(): CustomerManagedPolicyAttachmentArgs = CustomerManagedPolicyAttachmentArgs(
        customerManagedPolicyReference = customerManagedPolicyReference,
        instanceArn = instanceArn,
        permissionSetArn = permissionSetArn,
    )
}
