@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.kotlin.outputs.InstanceAccessControlAttributesAttribute
import com.pulumi.aws.ssoadmin.kotlin.outputs.InstanceAccessControlAttributesAttribute.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [InstanceAccessControlAttributes].
 */
@PulumiTagMarker
public class InstanceAccessControlAttributesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceAccessControlAttributesArgs = InstanceAccessControlAttributesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceAccessControlAttributesArgsBuilder.() -> Unit) {
        val builder = InstanceAccessControlAttributesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InstanceAccessControlAttributes {
        val builtJavaResource =
            com.pulumi.aws.ssoadmin.InstanceAccessControlAttributes(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return InstanceAccessControlAttributes(builtJavaResource)
    }
}

/**
 * Provides a Single Sign-On (SSO) ABAC Resource: https://docs.aws.amazon.com/singlesignon/latest/userguide/abac.html
 * ## Import
 * Using `pulumi import`, import SSO Account Assignments using the `instance_arn`. For example:
 * ```sh
 *  $ pulumi import aws:ssoadmin/instanceAccessControlAttributes:InstanceAccessControlAttributes example arn:aws:sso:::instance/ssoins-0123456789abcdef
 * ```
 *
 */
public class InstanceAccessControlAttributes internal constructor(
    override val javaResource: com.pulumi.aws.ssoadmin.InstanceAccessControlAttributes,
) : KotlinCustomResource(javaResource, InstanceAccessControlAttributesMapper) {
    /**
     * See AccessControlAttribute for more details.
     */
    public val attributes: Output<List<InstanceAccessControlAttributesAttribute>>
        get() = javaResource.attributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The Amazon Resource Name (ARN) of the SSO Instance.
     */
    public val instanceArn: Output<String>
        get() = javaResource.instanceArn().applyValue({ args0 -> args0 })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    public val statusReason: Output<String>
        get() = javaResource.statusReason().applyValue({ args0 -> args0 })
}

public object InstanceAccessControlAttributesMapper :
    ResourceMapper<InstanceAccessControlAttributes> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssoadmin.InstanceAccessControlAttributes::class == javaResource::class

    override fun map(javaResource: Resource): InstanceAccessControlAttributes =
        InstanceAccessControlAttributes(
            javaResource as
                com.pulumi.aws.ssoadmin.InstanceAccessControlAttributes,
        )
}

/**
 * @see [InstanceAccessControlAttributes].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceAccessControlAttributes].
 */
public suspend fun instanceAccessControlAttributes(
    name: String,
    block: suspend InstanceAccessControlAttributesResourceBuilder.() -> Unit,
):
    InstanceAccessControlAttributes {
    val builder = InstanceAccessControlAttributesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceAccessControlAttributes].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceAccessControlAttributes(name: String): InstanceAccessControlAttributes {
    val builder = InstanceAccessControlAttributesResourceBuilder()
    builder.name(name)
    return builder.build()
}
