@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.InstanceAccessControlAttributesArgs.builder
import com.pulumi.aws.ssoadmin.kotlin.inputs.InstanceAccessControlAttributesAttributeArgs
import com.pulumi.aws.ssoadmin.kotlin.inputs.InstanceAccessControlAttributesAttributeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Single Sign-On (SSO) ABAC Resource: https://docs.aws.amazon.com/singlesignon/latest/userguide/abac.html
 * ## Import
 * Using `pulumi import`, import SSO Account Assignments using the `instance_arn`. For example:
 * ```sh
 *  $ pulumi import aws:ssoadmin/instanceAccessControlAttributes:InstanceAccessControlAttributes example arn:aws:sso:::instance/ssoins-0123456789abcdef
 * ```
 * @property attributes See AccessControlAttribute for more details.
 * @property instanceArn The Amazon Resource Name (ARN) of the SSO Instance.
 */
public data class InstanceAccessControlAttributesArgs(
    public val attributes: Output<List<InstanceAccessControlAttributesAttributeArgs>>? = null,
    public val instanceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.InstanceAccessControlAttributesArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.InstanceAccessControlAttributesArgs =
        com.pulumi.aws.ssoadmin.InstanceAccessControlAttributesArgs.builder()
            .attributes(
                attributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .instanceArn(instanceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceAccessControlAttributesArgs].
 */
@PulumiTagMarker
public class InstanceAccessControlAttributesArgsBuilder internal constructor() {
    private var attributes: Output<List<InstanceAccessControlAttributesAttributeArgs>>? = null

    private var instanceArn: Output<String>? = null

    /**
     * @param value See AccessControlAttribute for more details.
     */
    @JvmName("bkifcysqjnjcrmcc")
    public suspend
    fun attributes(`value`: Output<List<InstanceAccessControlAttributesAttributeArgs>>) {
        this.attributes = value
    }

    @JvmName("axgybsusanwicdwl")
    public suspend fun attributes(
        vararg
        values: Output<InstanceAccessControlAttributesAttributeArgs>,
    ) {
        this.attributes = Output.all(values.asList())
    }

    /**
     * @param values See AccessControlAttribute for more details.
     */
    @JvmName("odhpygkemagerxoq")
    public suspend
    fun attributes(values: List<Output<InstanceAccessControlAttributesAttributeArgs>>) {
        this.attributes = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance.
     */
    @JvmName("vcekvdycouuminrm")
    public suspend fun instanceArn(`value`: Output<String>) {
        this.instanceArn = value
    }

    /**
     * @param value See AccessControlAttribute for more details.
     */
    @JvmName("vbsjigyikedlvsqn")
    public suspend fun attributes(`value`: List<InstanceAccessControlAttributesAttributeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param argument See AccessControlAttribute for more details.
     */
    @JvmName("mqctuhbajpnxhvus")
    public suspend
    fun attributes(argument: List<suspend InstanceAccessControlAttributesAttributeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceAccessControlAttributesAttributeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param argument See AccessControlAttribute for more details.
     */
    @JvmName("kbokfgyowwtcnuut")
    public suspend fun attributes(
        vararg
        argument: suspend InstanceAccessControlAttributesAttributeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InstanceAccessControlAttributesAttributeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param argument See AccessControlAttribute for more details.
     */
    @JvmName("bektjvdgpmjjghua")
    public suspend
    fun attributes(argument: suspend InstanceAccessControlAttributesAttributeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InstanceAccessControlAttributesAttributeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param values See AccessControlAttribute for more details.
     */
    @JvmName("nqavkhnwcxtdoxky")
    public suspend fun attributes(vararg values: InstanceAccessControlAttributesAttributeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance.
     */
    @JvmName("jimnmqmgsskfnjjt")
    public suspend fun instanceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceArn = mapped
    }

    internal fun build(): InstanceAccessControlAttributesArgs = InstanceAccessControlAttributesArgs(
        attributes = attributes,
        instanceArn = instanceArn,
    )
}
