@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ManagedPolicyAttachment].
 */
@PulumiTagMarker
public class ManagedPolicyAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedPolicyAttachmentArgs = ManagedPolicyAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedPolicyAttachmentArgsBuilder.() -> Unit) {
        val builder = ManagedPolicyAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagedPolicyAttachment {
        val builtJavaResource = com.pulumi.aws.ssoadmin.ManagedPolicyAttachment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ManagedPolicyAttachment(builtJavaResource)
    }
}

/**
 * Provides an IAM managed policy for a Single Sign-On (SSO) Permission Set resource
 * > **NOTE:** Creating this resource will automatically [Provision the Permission Set](https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ProvisionPermissionSet.html) to apply the corresponding updates to all assigned accounts.
 * ## Import
 * Using `pulumi import`, import SSO Managed Policy Attachments using the `managed_policy_arn`, `permission_set_arn`, and `instance_arn` separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ssoadmin/managedPolicyAttachment:ManagedPolicyAttachment example arn:aws:iam::aws:policy/AlexaForBusinessDeviceSetup,arn:aws:sso:::permissionSet/ssoins-2938j0x8920sbj72/ps-80383020jr9302rk,arn:aws:sso:::instance/ssoins-2938j0x8920sbj72
 * ```
 *
 */
public class ManagedPolicyAttachment internal constructor(
    override val javaResource: com.pulumi.aws.ssoadmin.ManagedPolicyAttachment,
) : KotlinCustomResource(javaResource, ManagedPolicyAttachmentMapper) {
    /**
     * The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    public val instanceArn: Output<String>
        get() = javaResource.instanceArn().applyValue({ args0 -> args0 })

    /**
     * The IAM managed policy Amazon Resource Name (ARN) to be attached to the Permission Set.
     */
    public val managedPolicyArn: Output<String>
        get() = javaResource.managedPolicyArn().applyValue({ args0 -> args0 })

    /**
     * The name of the IAM Managed Policy.
     */
    public val managedPolicyName: Output<String>
        get() = javaResource.managedPolicyName().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the Permission Set.
     */
    public val permissionSetArn: Output<String>
        get() = javaResource.permissionSetArn().applyValue({ args0 -> args0 })
}

public object ManagedPolicyAttachmentMapper : ResourceMapper<ManagedPolicyAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssoadmin.ManagedPolicyAttachment::class == javaResource::class

    override fun map(javaResource: Resource): ManagedPolicyAttachment =
        ManagedPolicyAttachment(javaResource as com.pulumi.aws.ssoadmin.ManagedPolicyAttachment)
}

/**
 * @see [ManagedPolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedPolicyAttachment].
 */
public suspend fun managedPolicyAttachment(
    name: String,
    block: suspend ManagedPolicyAttachmentResourceBuilder.() -> Unit,
): ManagedPolicyAttachment {
    val builder = ManagedPolicyAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedPolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedPolicyAttachment(name: String): ManagedPolicyAttachment {
    val builder = ManagedPolicyAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
