@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.ManagedPolicyAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IAM managed policy for a Single Sign-On (SSO) Permission Set resource
 * > **NOTE:** Creating this resource will automatically [Provision the Permission Set](https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ProvisionPermissionSet.html) to apply the corresponding updates to all assigned accounts.
 * ## Import
 * Using `pulumi import`, import SSO Managed Policy Attachments using the `managed_policy_arn`, `permission_set_arn`, and `instance_arn` separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ssoadmin/managedPolicyAttachment:ManagedPolicyAttachment example arn:aws:iam::aws:policy/AlexaForBusinessDeviceSetup,arn:aws:sso:::permissionSet/ssoins-2938j0x8920sbj72/ps-80383020jr9302rk,arn:aws:sso:::instance/ssoins-2938j0x8920sbj72
 * ```
 * @property instanceArn The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
 * @property managedPolicyArn The IAM managed policy Amazon Resource Name (ARN) to be attached to the Permission Set.
 * @property permissionSetArn The Amazon Resource Name (ARN) of the Permission Set.
 */
public data class ManagedPolicyAttachmentArgs(
    public val instanceArn: Output<String>? = null,
    public val managedPolicyArn: Output<String>? = null,
    public val permissionSetArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.ManagedPolicyAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.ManagedPolicyAttachmentArgs =
        com.pulumi.aws.ssoadmin.ManagedPolicyAttachmentArgs.builder()
            .instanceArn(instanceArn?.applyValue({ args0 -> args0 }))
            .managedPolicyArn(managedPolicyArn?.applyValue({ args0 -> args0 }))
            .permissionSetArn(permissionSetArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedPolicyAttachmentArgs].
 */
@PulumiTagMarker
public class ManagedPolicyAttachmentArgsBuilder internal constructor() {
    private var instanceArn: Output<String>? = null

    private var managedPolicyArn: Output<String>? = null

    private var permissionSetArn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    @JvmName("txudrcptbmqmdotj")
    public suspend fun instanceArn(`value`: Output<String>) {
        this.instanceArn = value
    }

    /**
     * @param value The IAM managed policy Amazon Resource Name (ARN) to be attached to the Permission Set.
     */
    @JvmName("qaeggnneoghtulpi")
    public suspend fun managedPolicyArn(`value`: Output<String>) {
        this.managedPolicyArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Permission Set.
     */
    @JvmName("ypniurcplcidwuhw")
    public suspend fun permissionSetArn(`value`: Output<String>) {
        this.permissionSetArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    @JvmName("jxlshaoxcifrmwam")
    public suspend fun instanceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceArn = mapped
    }

    /**
     * @param value The IAM managed policy Amazon Resource Name (ARN) to be attached to the Permission Set.
     */
    @JvmName("hqdltrtbxcxyofht")
    public suspend fun managedPolicyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedPolicyArn = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Permission Set.
     */
    @JvmName("xfaphnriewswfvvg")
    public suspend fun permissionSetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionSetArn = mapped
    }

    internal fun build(): ManagedPolicyAttachmentArgs = ManagedPolicyAttachmentArgs(
        instanceArn = instanceArn,
        managedPolicyArn = managedPolicyArn,
        permissionSetArn = permissionSetArn,
    )
}
