@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.PermissionSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Single Sign-On (SSO) Permission Set resource
 * > **NOTE:** Updating this resource will automatically [Provision the Permission Set](https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ProvisionPermissionSet.html) to apply the corresponding updates to all assigned accounts.
 * ## Import
 * Using `pulumi import`, import SSO Permission Sets using the `arn` and `instance_arn` separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ssoadmin/permissionSet:PermissionSet example arn:aws:sso:::permissionSet/ssoins-2938j0x8920sbj72/ps-80383020jr9302rk,arn:aws:sso:::instance/ssoins-2938j0x8920sbj72
 * ```
 * @property description The description of the Permission Set.
 * @property instanceArn The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
 * @property name The name of the Permission Set.
 * @property relayState The relay state URL used to redirect users within the application during the federation authentication process.
 * @property sessionDuration The length of time that the application user sessions are valid in the ISO-8601 standard. Default: `PT1H`.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class PermissionSetArgs(
    public val description: Output<String>? = null,
    public val instanceArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val relayState: Output<String>? = null,
    public val sessionDuration: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.PermissionSetArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.PermissionSetArgs =
        com.pulumi.aws.ssoadmin.PermissionSetArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceArn(instanceArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .relayState(relayState?.applyValue({ args0 -> args0 }))
            .sessionDuration(sessionDuration?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PermissionSetArgs].
 */
@PulumiTagMarker
public class PermissionSetArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var instanceArn: Output<String>? = null

    private var name: Output<String>? = null

    private var relayState: Output<String>? = null

    private var sessionDuration: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the Permission Set.
     */
    @JvmName("hlqocthqmlkmowxo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    @JvmName("nktjvlerwgogvafu")
    public suspend fun instanceArn(`value`: Output<String>) {
        this.instanceArn = value
    }

    /**
     * @param value The name of the Permission Set.
     */
    @JvmName("ctfbwiftncqmiwpt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The relay state URL used to redirect users within the application during the federation authentication process.
     */
    @JvmName("reixdeexkoaqrcdq")
    public suspend fun relayState(`value`: Output<String>) {
        this.relayState = value
    }

    /**
     * @param value The length of time that the application user sessions are valid in the ISO-8601 standard. Default: `PT1H`.
     */
    @JvmName("reafcvujbheqhahy")
    public suspend fun sessionDuration(`value`: Output<String>) {
        this.sessionDuration = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("unyblyqnhrjffynf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the Permission Set.
     */
    @JvmName("bmkvimoruedbbuxv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    @JvmName("tlnsmqcrtciaclbu")
    public suspend fun instanceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceArn = mapped
    }

    /**
     * @param value The name of the Permission Set.
     */
    @JvmName("uigyskkbfrrynenb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The relay state URL used to redirect users within the application during the federation authentication process.
     */
    @JvmName("qhjhaqqohlajamut")
    public suspend fun relayState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relayState = mapped
    }

    /**
     * @param value The length of time that the application user sessions are valid in the ISO-8601 standard. Default: `PT1H`.
     */
    @JvmName("iofjeyedaebtpubi")
    public suspend fun sessionDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionDuration = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fobbwbsovkrutgnx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ometiegxnxjvxuky")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PermissionSetArgs = PermissionSetArgs(
        description = description,
        instanceArn = instanceArn,
        name = name,
        relayState = relayState,
        sessionDuration = sessionDuration,
        tags = tags,
    )
}
