@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PermissionSetInlinePolicy].
 */
@PulumiTagMarker
public class PermissionSetInlinePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PermissionSetInlinePolicyArgs = PermissionSetInlinePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PermissionSetInlinePolicyArgsBuilder.() -> Unit) {
        val builder = PermissionSetInlinePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PermissionSetInlinePolicy {
        val builtJavaResource =
            com.pulumi.aws.ssoadmin.PermissionSetInlinePolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PermissionSetInlinePolicy(builtJavaResource)
    }
}

/**
 * Provides an IAM inline policy for a Single Sign-On (SSO) Permission Set resource
 * > **NOTE:** AWS Single Sign-On (SSO) only supports one IAM inline policy per `aws.ssoadmin.PermissionSet` resource.
 * Creating or updating this resource will automatically [Provision the Permission Set](https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ProvisionPermissionSet.html) to apply the corresponding updates to all assigned accounts.
 * ## Import
 * Using `pulumi import`, import SSO Permission Set Inline Policies using the `permission_set_arn` and `instance_arn` separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ssoadmin/permissionSetInlinePolicy:PermissionSetInlinePolicy example arn:aws:sso:::permissionSet/ssoins-2938j0x8920sbj72/ps-80383020jr9302rk,arn:aws:sso:::instance/ssoins-2938j0x8920sbj72
 * ```
 *
 */
public class PermissionSetInlinePolicy internal constructor(
    override val javaResource: com.pulumi.aws.ssoadmin.PermissionSetInlinePolicy,
) : KotlinCustomResource(javaResource, PermissionSetInlinePolicyMapper) {
    /**
     * The IAM inline policy to attach to a Permission Set.
     */
    public val inlinePolicy: Output<String>
        get() = javaResource.inlinePolicy().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    public val instanceArn: Output<String>
        get() = javaResource.instanceArn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the Permission Set.
     */
    public val permissionSetArn: Output<String>
        get() = javaResource.permissionSetArn().applyValue({ args0 -> args0 })
}

public object PermissionSetInlinePolicyMapper : ResourceMapper<PermissionSetInlinePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssoadmin.PermissionSetInlinePolicy::class == javaResource::class

    override fun map(javaResource: Resource): PermissionSetInlinePolicy =
        PermissionSetInlinePolicy(javaResource as com.pulumi.aws.ssoadmin.PermissionSetInlinePolicy)
}

/**
 * @see [PermissionSetInlinePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PermissionSetInlinePolicy].
 */
public suspend fun permissionSetInlinePolicy(
    name: String,
    block: suspend PermissionSetInlinePolicyResourceBuilder.() -> Unit,
): PermissionSetInlinePolicy {
    val builder = PermissionSetInlinePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PermissionSetInlinePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun permissionSetInlinePolicy(name: String): PermissionSetInlinePolicy {
    val builder = PermissionSetInlinePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
