@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.PermissionSetInlinePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an IAM inline policy for a Single Sign-On (SSO) Permission Set resource
 * > **NOTE:** AWS Single Sign-On (SSO) only supports one IAM inline policy per `aws.ssoadmin.PermissionSet` resource.
 * Creating or updating this resource will automatically [Provision the Permission Set](https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ProvisionPermissionSet.html) to apply the corresponding updates to all assigned accounts.
 * ## Import
 * Using `pulumi import`, import SSO Permission Set Inline Policies using the `permission_set_arn` and `instance_arn` separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ssoadmin/permissionSetInlinePolicy:PermissionSetInlinePolicy example arn:aws:sso:::permissionSet/ssoins-2938j0x8920sbj72/ps-80383020jr9302rk,arn:aws:sso:::instance/ssoins-2938j0x8920sbj72
 * ```
 * @property inlinePolicy The IAM inline policy to attach to a Permission Set.
 * @property instanceArn The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
 * @property permissionSetArn The Amazon Resource Name (ARN) of the Permission Set.
 */
public data class PermissionSetInlinePolicyArgs(
    public val inlinePolicy: Output<String>? = null,
    public val instanceArn: Output<String>? = null,
    public val permissionSetArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.PermissionSetInlinePolicyArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.PermissionSetInlinePolicyArgs =
        com.pulumi.aws.ssoadmin.PermissionSetInlinePolicyArgs.builder()
            .inlinePolicy(inlinePolicy?.applyValue({ args0 -> args0 }))
            .instanceArn(instanceArn?.applyValue({ args0 -> args0 }))
            .permissionSetArn(permissionSetArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PermissionSetInlinePolicyArgs].
 */
@PulumiTagMarker
public class PermissionSetInlinePolicyArgsBuilder internal constructor() {
    private var inlinePolicy: Output<String>? = null

    private var instanceArn: Output<String>? = null

    private var permissionSetArn: Output<String>? = null

    /**
     * @param value The IAM inline policy to attach to a Permission Set.
     */
    @JvmName("ebbtidsohgtjabnl")
    public suspend fun inlinePolicy(`value`: Output<String>) {
        this.inlinePolicy = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    @JvmName("xglfypnrkdgldhlv")
    public suspend fun instanceArn(`value`: Output<String>) {
        this.instanceArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Permission Set.
     */
    @JvmName("viulellpicwvpdvn")
    public suspend fun permissionSetArn(`value`: Output<String>) {
        this.permissionSetArn = value
    }

    /**
     * @param value The IAM inline policy to attach to a Permission Set.
     */
    @JvmName("uitbatkuqjgqfotl")
    public suspend fun inlinePolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inlinePolicy = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    @JvmName("qshqclesvcjhieml")
    public suspend fun instanceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceArn = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Permission Set.
     */
    @JvmName("gfkmskactxbfqijg")
    public suspend fun permissionSetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionSetArn = mapped
    }

    internal fun build(): PermissionSetInlinePolicyArgs = PermissionSetInlinePolicyArgs(
        inlinePolicy = inlinePolicy,
        instanceArn = instanceArn,
        permissionSetArn = permissionSetArn,
    )
}
