@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.kotlin.outputs.PermissionsBoundaryAttachmentPermissionsBoundary
import com.pulumi.aws.ssoadmin.kotlin.outputs.PermissionsBoundaryAttachmentPermissionsBoundary.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PermissionsBoundaryAttachment].
 */
@PulumiTagMarker
public class PermissionsBoundaryAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PermissionsBoundaryAttachmentArgs = PermissionsBoundaryAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PermissionsBoundaryAttachmentArgsBuilder.() -> Unit) {
        val builder = PermissionsBoundaryAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PermissionsBoundaryAttachment {
        val builtJavaResource =
            com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PermissionsBoundaryAttachment(builtJavaResource)
    }
}

/**
 * Attaches a permissions boundary policy to a Single Sign-On (SSO) Permission Set resource.
 * > **NOTE:** A permission set can have at most one permissions boundary attached; using more than one `aws.ssoadmin.PermissionsBoundaryAttachment` references the same permission set will show a permanent difference.
 * ## Example Usage
 * ### Attaching an AWS-managed policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachment;
 * import com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachmentArgs;
 * import com.pulumi.aws.ssoadmin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PermissionsBoundaryAttachment("example", PermissionsBoundaryAttachmentArgs.builder()
 *             .instanceArn(aws_ssoadmin_permission_set.example().instance_arn())
 *             .permissionSetArn(aws_ssoadmin_permission_set.example().arn())
 *             .permissionsBoundary(PermissionsBoundaryAttachmentPermissionsBoundaryArgs.builder()
 *                 .managedPolicyArn("arn:aws:iam::aws:policy/ReadOnlyAccess")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSO Admin Permissions Boundary Attachments using the `permission_set_arn` and `instance_arn`, separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ssoadmin/permissionsBoundaryAttachment:PermissionsBoundaryAttachment example arn:aws:sso:::permissionSet/ssoins-2938j0x8920sbj72/ps-80383020jr9302rk,arn:aws:sso:::instance/ssoins-2938j0x8920sbj72
 * ```
 *
 */
public class PermissionsBoundaryAttachment internal constructor(
    override val javaResource: com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachment,
) : KotlinCustomResource(javaResource, PermissionsBoundaryAttachmentMapper) {
    /**
     * The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    public val instanceArn: Output<String>
        get() = javaResource.instanceArn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the Permission Set.
     */
    public val permissionSetArn: Output<String>
        get() = javaResource.permissionSetArn().applyValue({ args0 -> args0 })

    /**
     * The permissions boundary policy. See below.
     */
    public val permissionsBoundary: Output<PermissionsBoundaryAttachmentPermissionsBoundary>
        get() = javaResource.permissionsBoundary().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })
}

public object PermissionsBoundaryAttachmentMapper : ResourceMapper<PermissionsBoundaryAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachment::class == javaResource::class

    override fun map(javaResource: Resource): PermissionsBoundaryAttachment =
        PermissionsBoundaryAttachment(
            javaResource as
                com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachment,
        )
}

/**
 * @see [PermissionsBoundaryAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PermissionsBoundaryAttachment].
 */
public suspend fun permissionsBoundaryAttachment(
    name: String,
    block: suspend PermissionsBoundaryAttachmentResourceBuilder.() -> Unit,
):
    PermissionsBoundaryAttachment {
    val builder = PermissionsBoundaryAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PermissionsBoundaryAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun permissionsBoundaryAttachment(name: String): PermissionsBoundaryAttachment {
    val builder = PermissionsBoundaryAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
