@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachmentArgs.builder
import com.pulumi.aws.ssoadmin.kotlin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryArgs
import com.pulumi.aws.ssoadmin.kotlin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Attaches a permissions boundary policy to a Single Sign-On (SSO) Permission Set resource.
 * > **NOTE:** A permission set can have at most one permissions boundary attached; using more than one `aws.ssoadmin.PermissionsBoundaryAttachment` references the same permission set will show a permanent difference.
 * ## Example Usage
 * ### Attaching an AWS-managed policy
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachment;
 * import com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachmentArgs;
 * import com.pulumi.aws.ssoadmin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PermissionsBoundaryAttachment("example", PermissionsBoundaryAttachmentArgs.builder()
 *             .instanceArn(aws_ssoadmin_permission_set.example().instance_arn())
 *             .permissionSetArn(aws_ssoadmin_permission_set.example().arn())
 *             .permissionsBoundary(PermissionsBoundaryAttachmentPermissionsBoundaryArgs.builder()
 *                 .managedPolicyArn("arn:aws:iam::aws:policy/ReadOnlyAccess")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SSO Admin Permissions Boundary Attachments using the `permission_set_arn` and `instance_arn`, separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:ssoadmin/permissionsBoundaryAttachment:PermissionsBoundaryAttachment example arn:aws:sso:::permissionSet/ssoins-2938j0x8920sbj72/ps-80383020jr9302rk,arn:aws:sso:::instance/ssoins-2938j0x8920sbj72
 * ```
 * @property instanceArn The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
 * @property permissionSetArn The Amazon Resource Name (ARN) of the Permission Set.
 * @property permissionsBoundary The permissions boundary policy. See below.
 */
public data class PermissionsBoundaryAttachmentArgs(
    public val instanceArn: Output<String>? = null,
    public val permissionSetArn: Output<String>? = null,
    public val permissionsBoundary: Output<PermissionsBoundaryAttachmentPermissionsBoundaryArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachmentArgs =
        com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachmentArgs.builder()
            .instanceArn(instanceArn?.applyValue({ args0 -> args0 }))
            .permissionSetArn(permissionSetArn?.applyValue({ args0 -> args0 }))
            .permissionsBoundary(
                permissionsBoundary?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [PermissionsBoundaryAttachmentArgs].
 */
@PulumiTagMarker
public class PermissionsBoundaryAttachmentArgsBuilder internal constructor() {
    private var instanceArn: Output<String>? = null

    private var permissionSetArn: Output<String>? = null

    private var permissionsBoundary: Output<PermissionsBoundaryAttachmentPermissionsBoundaryArgs>? =
        null

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    @JvmName("ertftahmylyhebgc")
    public suspend fun instanceArn(`value`: Output<String>) {
        this.instanceArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Permission Set.
     */
    @JvmName("ipjannaanuqbigju")
    public suspend fun permissionSetArn(`value`: Output<String>) {
        this.permissionSetArn = value
    }

    /**
     * @param value The permissions boundary policy. See below.
     */
    @JvmName("bnptnvkkpjjcfgeu")
    public suspend
    fun permissionsBoundary(`value`: Output<PermissionsBoundaryAttachmentPermissionsBoundaryArgs>) {
        this.permissionsBoundary = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    @JvmName("bcayxvpmyetbiqff")
    public suspend fun instanceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceArn = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Permission Set.
     */
    @JvmName("rglwgxpbhqmdydvb")
    public suspend fun permissionSetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionSetArn = mapped
    }

    /**
     * @param value The permissions boundary policy. See below.
     */
    @JvmName("qkxqhtceohhrqmap")
    public suspend
    fun permissionsBoundary(`value`: PermissionsBoundaryAttachmentPermissionsBoundaryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionsBoundary = mapped
    }

    /**
     * @param argument The permissions boundary policy. See below.
     */
    @JvmName("ilqcssurgloayvdt")
    public suspend
    fun permissionsBoundary(argument: suspend PermissionsBoundaryAttachmentPermissionsBoundaryArgsBuilder.() -> Unit) {
        val toBeMapped = PermissionsBoundaryAttachmentPermissionsBoundaryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.permissionsBoundary = mapped
    }

    internal fun build(): PermissionsBoundaryAttachmentArgs = PermissionsBoundaryAttachmentArgs(
        instanceArn = instanceArn,
        permissionSetArn = permissionSetArn,
        permissionsBoundary = permissionsBoundary,
    )
}
