@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.SsoadminFunctions.getInstancesPlain
import com.pulumi.aws.ssoadmin.SsoadminFunctions.getPermissionSetPlain
import com.pulumi.aws.ssoadmin.kotlin.inputs.GetPermissionSetPlainArgs
import com.pulumi.aws.ssoadmin.kotlin.inputs.GetPermissionSetPlainArgsBuilder
import com.pulumi.aws.ssoadmin.kotlin.outputs.GetInstancesResult
import com.pulumi.aws.ssoadmin.kotlin.outputs.GetPermissionSetResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.ssoadmin.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.aws.ssoadmin.kotlin.outputs.GetPermissionSetResult.Companion.toKotlin as getPermissionSetResultToKotlin

public object SsoadminFunctions {
    /**
     * Use this data source to get ARNs and Identity Store IDs of Single Sign-On (SSO) Instances.
     * @param argument Use this data source to get ARNs and Identity Store IDs of Single Sign-On (SSO) Instances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain().await())

    /**
     * Use this data source to get a Single Sign-On (SSO) Permission Set.
     * @param argument A collection of arguments for invoking getPermissionSet.
     * @return A collection of values returned by getPermissionSet.
     */
    public suspend fun getPermissionSet(argument: GetPermissionSetPlainArgs): GetPermissionSetResult =
        getPermissionSetResultToKotlin(getPermissionSetPlain(argument.toJava()).await())

    /**
     * @see [getPermissionSet].
     * @param arn ARN of the permission set.
     * @param instanceArn ARN of the SSO Instance associated with the permission set.
     * @param name Name of the SSO Permission Set.
     * @param tags Key-value map of resource tags.
     * @return A collection of values returned by getPermissionSet.
     */
    public suspend fun getPermissionSet(
        arn: String? = null,
        instanceArn: String,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetPermissionSetResult {
        val argument = GetPermissionSetPlainArgs(
            arn = arn,
            instanceArn = instanceArn,
            name = name,
            tags = tags,
        )
        return getPermissionSetResultToKotlin(getPermissionSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getPermissionSet].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssoadmin&#46;kotlin&#46;inputs&#46;GetPermissionSetPlainArgs].
     * @return A collection of values returned by getPermissionSet.
     */
    public suspend
    fun getPermissionSet(argument: suspend GetPermissionSetPlainArgsBuilder.() -> Unit):
        GetPermissionSetResult {
        val builder = GetPermissionSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPermissionSetResultToKotlin(getPermissionSetPlain(builtArgument.toJava()).await())
    }
}
