@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.GetPermissionSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPermissionSet.
 * @property arn ARN of the permission set.
 * @property instanceArn ARN of the SSO Instance associated with the permission set.
 * @property name Name of the SSO Permission Set.
 * @property tags Key-value map of resource tags.
 */
public data class GetPermissionSetPlainArgs(
    public val arn: String? = null,
    public val instanceArn: String,
    public val name: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.GetPermissionSetPlainArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.GetPermissionSetPlainArgs =
        com.pulumi.aws.ssoadmin.inputs.GetPermissionSetPlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .instanceArn(instanceArn.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetPermissionSetPlainArgs].
 */
@PulumiTagMarker
public class GetPermissionSetPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var instanceArn: String? = null

    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN of the permission set.
     */
    @JvmName("qlewhhdqcabxwhup")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value ARN of the SSO Instance associated with the permission set.
     */
    @JvmName("phpbskwuybhthnjc")
    public suspend fun instanceArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceArn = mapped
    }

    /**
     * @param value Name of the SSO Permission Set.
     */
    @JvmName("agimaktddtibbnes")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags.
     */
    @JvmName("wxgtoyadjijoldtn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags.
     */
    @JvmName("nbshvmgmkdvidjiu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetPermissionSetPlainArgs = GetPermissionSetPlainArgs(
        arn = arn,
        instanceArn = instanceArn ?: throw PulumiNullFieldException("instanceArn"),
        name = name,
        tags = tags,
    )
}
